/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.gm.NoteMemoPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemActionPanel
implements SelectablePanel {
    private static final Log log_s_ = LogFactory.getLog(ProblemActionPanel.class);
    private static final ImageResource QUESTION = new ImageResource(ProblemActionPanel.class, "problem00.png");
    private static final ImageResource CORRECT = new ImageResource(ProblemActionPanel.class, "problem01.png");
    private static final ImageResource QUASI_CORRECT = new ImageResource(ProblemActionPanel.class, "problem02.png");
    private static final ImageResource WRONG = new ImageResource(ProblemActionPanel.class, "problem03.png");
    private static final MessageResource CLB_GIVEUP = new MessageResource(ProblemActionPanel.class, "clbGiveup");
    private static final MessageResource CLB_RETRY = new MessageResource(ProblemActionPanel.class, "clbRetry");
    private static final MessageResource CLB_PREVIOUS = new MessageResource(ProblemActionPanel.class, "clbPrevious");
    private static final MessageResource CLB_NEXT = new MessageResource(ProblemActionPanel.class, "clbNext");
    private Reference<CollectionEditor> refCe_ = new WeakReference<Object>(null);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Control rootControl_ = null;
    private final Adapter adapter_ = new Adapter();
    private Label imageLabel_ = null;
    private Button giveup_ = null;
    private Button retry_ = null;
    private Button previous_ = null;
    private Button next_ = null;
    private final NoteMemoPanel noteMemoPanel_ = new NoteMemoPanel(false);

    @Override
    public Control createContents(Composite composite) {
        USashForm uSashForm = WidgetFactory.createUSashForm(composite, 512);
        Composite composite2 = new Composite(uSashForm, 0);
        composite2.setLayout(new FillLayout(512));
        this.imageLabel_ = new Label(composite2, 2052);
        this.imageLabel_.setImage(QUESTION.get());
        Composite composite3 = new Composite(composite2, 2048);
        composite3.setLayout(new RowLayout(512));
        this.giveup_ = new Button(composite3, 8);
        this.giveup_.setText(CLB_GIVEUP.get());
        this.giveup_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.ANSWER));
            }
        });
        this.retry_ = new Button(composite3, 8);
        this.retry_.setText(CLB_RETRY.get());
        this.retry_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
            }
        });
        this.previous_ = new Button(composite3, 8);
        this.previous_.setText(CLB_PREVIOUS.get());
        this.previous_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
                int n = collectionEditor.getActiveGameIndex();
                if (n == 0) {
                    log_s_.warn("(BUG)Can't go to previous problem because of zero index, ignore it.");
                } else {
                    collectionEditor.getActiveGame().finishSolvingProblem();
                    ProblemActionPanel.this.eventBroker_.executeCommand(new GameChangeCommand(--n));
                    ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
                }
            }
        });
        this.next_ = new Button(composite3, 8);
        this.next_.setText(CLB_NEXT.get());
        this.next_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
                int n = collectionEditor.getActiveGameIndex();
                if (collectionEditor.size() <= n + 1) {
                    log_s_.warn("(BUG)Can't go to next problem because of max index:" + n);
                } else {
                    collectionEditor.getActiveGame().finishSolvingProblem();
                    ProblemActionPanel.this.eventBroker_.executeCommand(new GameChangeCommand(++n));
                    ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
                }
            }
        });
        this.noteMemoPanel_.createContents(uSashForm);
        uSashForm.setWeights(new int[]{2, 1});
        this.rootControl_ = uSashForm;
        return this.rootControl_;
    }

    @Override
    public void dispose() {
        this.noteMemoPanel_.dispose();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.rootControl_;
    }

    private class Adapter
    implements ModelEventNotifier,
    CollectionMonitor,
    GameMonitor,
    ControllerStatusMonitor,
    ProblemStatusMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            ProblemActionPanel.this.eventBroker_.removeView(ProblemActionPanel.this);
            ProblemActionPanel.this.eventBroker_ = eventBroker;
            ProblemActionPanel.this.eventBroker_.addView(ProblemActionPanel.this);
            ProblemActionPanel.this.eventBroker_.addView(ProblemActionPanel.this.noteMemoPanel_);
        }

        public void update(CollectionEditor collectionEditor) {
            ProblemActionPanel.this.refCe_ = new WeakReference<CollectionEditor>(collectionEditor);
        }

        public void update(GameMediator gameMediator) {
            CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
            if (collectionEditor == null) {
                ProblemActionPanel.this.next_.setEnabled(false);
            }
            ProblemActionPanel.this.next_.setEnabled(collectionEditor.getActiveGameIndex() != collectionEditor.size() - 1);
            int n = collectionEditor.getActiveGameIndex();
            ProblemActionPanel.this.previous_.setEnabled(!collectionEditor.isDrill() && 1 <= n || 2 <= n);
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(HandlerPhase.SOLVE)) {
                this.updateStatusImpl(QUESTION, true, false);
            } else if (handlerPhase.equals(HandlerPhase.ANSWER)) {
                this.updateStatusImpl(QUESTION, false, true);
            }
        }

        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            if (problemStatus.equals(ProblemStatus.SOLVE)) {
                this.updateStatusImpl(QUESTION, true, false);
            } else if (problemStatus.equals(ProblemStatus.CORRECT)) {
                this.updateStatusImpl(CORRECT, false, true);
            } else if (problemStatus.equals(ProblemStatus.QUASI_CORRECT)) {
                this.updateStatusImpl(QUASI_CORRECT, false, true);
            } else if (problemStatus.equals(ProblemStatus.WRONG)) {
                this.updateStatusImpl(WRONG, false, true);
            }
        }

        private void updateStatusImpl(ImageResource imageResource, boolean bl, boolean bl2) {
            ProblemActionPanel.this.imageLabel_.setImage(imageResource.get());
            ProblemActionPanel.this.giveup_.setEnabled(bl);
            ProblemActionPanel.this.retry_.setEnabled(bl2);
        }
    }
}

