/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.util;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.lang.NamedEnum;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UEnumCombo<T extends UEnum>
implements WidgetContainer {
    private static final MessageResource LB_EMPTY = new MessageResource(UEnumCombo.class, "lbEmpty");
    private final Class<T> clazz_;
    private Combo combo_;

    public UEnumCombo(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        if (!UEnum.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        this.clazz_ = clazz;
    }

    @Override
    public Control createContents(Composite composite) {
        this.combo_ = new Combo(composite, 12);
        this.combo_.add(LB_EMPTY.get());
        UEnum[] uEnumArray = UEnum.getAll(this.clazz_);
        for (int i = 0; i < uEnumArray.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uEnumArray[i].typeName());
            if (uEnumArray[i] instanceof NamedEnum) {
                stringBuilder.append(':').append(((NamedEnum)uEnumArray[i]).displayName());
            }
            this.combo_.add(stringBuilder.toString());
        }
        if (this.combo_.getItemCount() != 0) {
            this.combo_.select(0);
        }
        return this.combo_;
    }

    public void select(UEnum uEnum) {
        if (uEnum == null) {
            this.combo_.select(0);
            return;
        }
        int n = 1;
        UEnum[] uEnumArray = UEnum.getAll(this.clazz_);
        for (int i = 0; i < uEnumArray.length; ++i) {
            if (uEnumArray[i].equals(uEnum)) {
                this.combo_.select(n);
                return;
            }
            ++n;
        }
        assert (false) : "Unknown enumElement :" + uEnum;
    }

    public void setText(String string) {
        this.combo_.setText(string);
    }

    public Combo getCombo() {
        return this.combo_;
    }

    @Override
    public void dispose() {
    }

    public void setEditable(boolean bl) {
        this.combo_.setEnabled(bl);
    }

    public UEnum getSelected() {
        int n = this.combo_.getSelectionIndex();
        if (n <= 0) {
            return null;
        }
        return UEnum.getAll(this.clazz_)[--n];
    }

    public String getSelectedDatum() {
        int n = this.combo_.getSelectionIndex();
        if (n == 0) {
            return "";
        }
        if (n == -1) {
            return this.combo_.getText();
        }
        UEnum[] uEnumArray = UEnum.getAll(this.clazz_);
        return uEnumArray[--n].typeName().toString();
    }

    public boolean getEditable() {
        return this.combo_.getEnabled();
    }
}

