/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMUPDOWN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.UDACCEL;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class USpinner
extends Composite {
    private static final Log log_s_ = LogFactory.getLog(USpinner.class);
    static final int EditProc;
    static final TCHAR EditClass;
    static final int UpDownProc;
    static final TCHAR UpDownClass;
    int hwndText;
    int hwndUpDown;
    boolean ignoreModify;
    int pageIncrement;
    int digits;
    private int digitsPow10_;

    public USpinner(Composite composite, int n) {
        super(composite, USpinner.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n == this.hwndText) {
            return OS.CallWindowProc((int)EditProc, (int)n, (int)n2, (int)n3, (int)n4);
        }
        if (n == this.hwndUpDown) {
            return OS.CallWindowProc((int)UpDownProc, (int)n, (int)n2, (int)n3, (int)n4);
        }
        return OS.DefWindowProc((int)this.handle, (int)n2, (int)n3, (int)n4);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    boolean checkHandle(int n) {
        return n == this.handle || n == this.hwndText || n == this.hwndUpDown;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        int n = OS.GetModuleHandle(null);
        int n2 = (this.style & 0x800) != 0 ? 512 : 0;
        int n3 = 0x50000080;
        if ((this.style & 8) != 0) {
            n3 |= 0x800;
        }
        if (OS.WIN32_VERSION >= OS.VERSION((int)4, (int)10) && (this.style & 0x4000000) != 0) {
            n2 |= 0x400000;
        }
        this.hwndText = OS.CreateWindowEx((int)n2, (TCHAR)EditClass, null, (int)n3, (int)0, (int)0, (int)0, (int)0, (int)this.handle, (int)0, (int)n, null);
        if (this.hwndText == 0) {
            this.error(2);
        }
        OS.SetWindowLong((int)this.hwndText, (int)-12, (int)this.hwndText);
        int n4 = 0x50000000;
        if ((this.style & 0x40) != 0) {
            n4 |= 1;
        }
        this.hwndUpDown = OS.CreateWindowEx((int)0, (TCHAR)UpDownClass, null, (int)n4, (int)0, (int)0, (int)0, (int)0, (int)this.handle, (int)0, (int)n, null);
        if (this.hwndUpDown == 0) {
            this.error(2);
        }
        OS.SetWindowLong((int)this.hwndUpDown, (int)-12, (int)this.hwndUpDown);
        if (OS.IsDBLocale) {
            int n5 = OS.ImmGetContext((int)this.handle);
            OS.ImmAssociateContext((int)this.hwndText, (int)n5);
            OS.ImmAssociateContext((int)this.hwndUpDown, (int)n5);
            OS.ImmReleaseContext((int)this.handle, (int)n5);
        }
        OS.SendMessage((int)this.hwndUpDown, (int)1135, (int)0, (int)100);
        OS.SendMessage((int)this.hwndUpDown, (int)(OS.IsWinCE ? 1127 : 1137), (int)0, (int)0);
        this.pageIncrement = 10;
        this.digits = 0;
        this.digitsPow10_ = 1;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), "0", true);
        OS.SetWindowText((int)this.hwndText, (TCHAR)tCHAR);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)verifyListener);
        this.addListener(25, (Listener)typedListener);
    }

    int borderHandle() {
        return this.hwndText;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            int n5;
            StringBuffer stringBuffer;
            int n6 = 0;
            int n7 = OS.GetDC((int)this.hwndText);
            int n8 = OS.SendMessage((int)this.hwndText, (int)49, (int)0, (int)0);
            if (n8 != 0) {
                n6 = OS.SelectObject((int)n7, (int)n8);
            }
            TEXTMETRICW tEXTMETRICW = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics((int)n7, (TEXTMETRIC)tEXTMETRICW);
            n4 = tEXTMETRICW.tmHeight;
            RECT rECT = new RECT();
            int[] nArray = new int[1];
            OS.SendMessage((int)this.hwndUpDown, (int)1136, null, (int[])nArray);
            String string = String.valueOf(nArray[0]);
            if (this.digits > 0) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append(this.getDecimalSeparator());
                for (n5 = this.digits - string.length(); n5 >= 0; --n5) {
                    stringBuffer.append("0");
                }
                string = stringBuffer.toString();
            }
            stringBuffer = new TCHAR(this.getCodePage(), string, false);
            n5 = 11264;
            OS.DrawText((int)n7, (TCHAR)stringBuffer, (int)stringBuffer.length(), (RECT)rECT, (int)n5);
            n3 = rECT.right - rECT.left;
            if (n8 != 0) {
                OS.SelectObject((int)n7, (int)n6);
            }
            OS.ReleaseDC((int)this.hwndText, (int)n7);
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        if (n2 == -1) {
            rectangle.height = Math.max(rectangle.height, OS.GetSystemMetrics((int)20));
        }
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect((RECT)rECT, (int)n, (int)n2, (int)(n + n3), (int)(n2 + n4));
        int n5 = OS.GetWindowLong((int)this.hwndText, (int)-16);
        int n6 = OS.GetWindowLong((int)this.hwndText, (int)-20);
        OS.AdjustWindowRectEx((RECT)rECT, (int)n5, (boolean)false, (int)n6);
        n3 = rECT.right - rECT.left;
        n4 = rECT.bottom - rECT.top;
        int n7 = OS.SendMessage((int)this.hwndText, (int)212, (int)0, (int)0);
        n -= n7 & 0xFFFF;
        n3 += (n7 & 0xFFFF) + (n7 >> 16 & 0xFFFF);
        if ((this.style & 0x800) != 0) {
            --n;
            --n2;
            n3 += 2;
            n4 += 2;
        }
        return new Rectangle(n, n2, n3 += OS.GetSystemMetrics((int)2), n4);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage((int)this.hwndText, (int)769, (int)0, (int)0);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage((int)this.hwndText, (int)768, (int)0, (int)0);
    }

    int defaultBackground() {
        return OS.GetSysColor((int)OS.COLOR_WINDOW);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        OS.EnableWindow((int)this.hwndText, (boolean)bl);
        OS.EnableWindow((int)this.hwndUpDown, (boolean)bl);
    }

    void deregister() {
        super.deregister();
        this.display.removeControl(this.hwndText);
        this.display.removeControl(this.hwndUpDown);
    }

    boolean hasFocus() {
        int n = OS.GetFocus();
        if (n == this.handle) {
            return true;
        }
        if (n == this.hwndText) {
            return true;
        }
        return n == this.hwndUpDown;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n = OS.GetLocaleInfo((int)1024, (int)14, (TCHAR)tCHAR, (int)4);
        return n != 0 ? tCHAR.toString(0, n - 1) : ".";
    }

    public int getIncrement() {
        this.checkWidget();
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage((int)this.hwndUpDown, (int)1132, (int)1, (UDACCEL)uDACCEL);
        return uDACCEL.nInc;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage((int)this.hwndUpDown, (int)1136, null, (int[])nArray);
        return nArray[0];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray, null);
        return nArray[0];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return OS.SendMessage((int)this.hwndUpDown, (int)1128, (int)0, (int)0) & 0xFFFF;
        }
        return OS.SendMessage((int)this.hwndUpDown, (int)1138, (int)0, (int)0);
    }

    int getSelectionText() {
        String string = this.getText();
        try {
            int n = this.digits > 0 ? (int)(Double.parseDouble(string) * (double)this.digitsPow10_) : Integer.parseInt(string);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray2, (int[])nArray);
            if (nArray2[0] <= n && n <= nArray[0]) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            log_s_.warn((Object)("Text data is broken, ignore this:" + string), (Throwable)numberFormatException);
        }
        if (OS.IsWinCE) {
            return OS.SendMessage((int)this.hwndUpDown, (int)1128, (int)0, (int)0) & 0xFFFF;
        }
        return OS.SendMessage((int)this.hwndUpDown, (int)1138, (int)0, (int)0);
    }

    public String getText() {
        int n = OS.GetWindowTextLength((int)this.hwndText);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText((int)this.hwndText, (TCHAR)tCHAR, (int)(n + 1));
        return tCHAR.toString(0, n);
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = OS.GetWindowTextLengthA((int)this.hwndText);
        if (n2 == 0) {
            return 0;
        }
        if (n >= n2) {
            return n2;
        }
        byte[] byArray = new byte[n2 + 1];
        OS.GetWindowTextA((int)this.hwndText, (byte[])byArray, (int)(n2 + 1));
        return OS.MultiByteToWideChar((int)this.getCodePage(), (int)1, (byte[])byArray, (int)n, null, (int)0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage((int)this.hwndText, (int)770, (int)0, (int)0);
    }

    void register() {
        super.register();
        this.display.addControl(this.hwndText, (Control)this);
        this.display.addControl(this.hwndUpDown, (Control)this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndUpDown = 0;
        this.hwndText = 0;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, (SWTEventListener)modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, (SWTEventListener)selectionListener);
        this.eventTable.unhook(14, (SWTEventListener)selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, (SWTEventListener)verifyListener);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n, n2, n3, n4, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        char c = event.character;
        int n5 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n5 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState((int)1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage((int)this.hwndText, (int)176, (int[])nArray, (int[])nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage((int)this.hwndText, (int)177, (int)nArray[0], (int)nArray2[0]);
                    OS.SendMessage((int)this.hwndText, (int)176, (int[])object2, (int[])object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n6 = OS.GetWindowTextLength((int)this.hwndText);
                if (nArray[0] == n6) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage((int)this.hwndText, (int)177, (int)nArray[0], (int)nArray2[0]);
                    OS.SendMessage((int)this.hwndText, (int)176, (int[])object, (int[])nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n6);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string = new String(new char[]{c});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage((int)this.hwndText, (int)177, (int)nArray[0], (int)nArray2[0]);
        OS.SendMessage((int)this.hwndText, (int)194, (int)0, (TCHAR)object);
        return false;
    }

    void setBackgroundPixel(int n) {
        if (this.background == n) {
            return;
        }
        super.setBackgroundPixel(n);
        OS.InvalidateRect((int)this.hwndText, null, (boolean)true);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == this.digits) {
            return;
        }
        this.digits = n;
        this.digitsPow10_ = (int)Math.pow(10.0, this.digits);
        int n2 = OS.IsWinCE ? OS.SendMessage((int)this.hwndUpDown, (int)1128, (int)0, (int)0) & 0xFFFF : OS.SendMessage((int)this.hwndUpDown, (int)1138, (int)0, (int)0);
        this.setSelection(n2, false);
    }

    void setForegroundPixel(int n) {
        if (this.foreground == n) {
            return;
        }
        super.setForegroundPixel(n);
        OS.InvalidateRect((int)this.hwndText, null, (boolean)true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.GetProcessHeap();
        int n3 = OS.SendMessage((int)this.hwndUpDown, (int)1132, (int)0, (UDACCEL)null);
        int n4 = OS.HeapAlloc((int)n2, (int)8, (int)(8 * n3));
        OS.SendMessage((int)this.hwndUpDown, (int)1132, (int)n3, (int)n4);
        int n5 = -1;
        UDACCEL uDACCEL = new UDACCEL();
        for (int i = 0; i < n3; ++i) {
            int n6 = n4 + i * 8;
            OS.MoveMemory((UDACCEL)uDACCEL, (int)n6, (int)8);
            if (n5 == -1) {
                n5 = uDACCEL.nInc;
            }
            uDACCEL.nInc = uDACCEL.nInc * n / n5;
            OS.MoveMemory((int)n6, (UDACCEL)uDACCEL, (int)8);
        }
        OS.SendMessage((int)this.hwndUpDown, (int)1131, (int)n3, (int)n4);
        OS.HeapFree((int)n2, (int)0, (int)n4);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray, null);
        if (n <= nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.SendMessage((int)this.hwndUpDown, (int)1128, (int)0, (int)0) & 0xFFFF : OS.SendMessage((int)this.hwndUpDown, (int)1138, (int)0, (int)0);
        OS.SendMessage((int)this.hwndUpDown, (int)1135, (int)nArray[0], (int)n);
        if (n2 > n) {
            this.setSelection(n, false);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.SendMessage((int)this.hwndUpDown, (int)1136, null, (int[])nArray);
        if (n >= nArray[0]) {
            return;
        }
        int n2 = OS.IsWinCE ? OS.SendMessage((int)this.hwndUpDown, (int)1128, (int)0, (int)0) & 0xFFFF : OS.SendMessage((int)this.hwndUpDown, (int)1138, (int)0, (int)0);
        OS.SendMessage((int)this.hwndUpDown, (int)1135, (int)n, (int)nArray[0]);
        if (n2 < n) {
            this.setSelection(n, false);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray2, (int[])nArray);
        n = Math.min(Math.max(nArray2[0], n), nArray[0]);
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        int n2;
        String string;
        OS.SendMessage((int)this.hwndUpDown, (int)(OS.IsWinCE ? 1127 : 1137), (int)0, (int)n);
        String string2 = String.valueOf(n);
        if (this.digits > 0) {
            string = this.getDecimalSeparator();
            int n3 = string2.length() - this.digits;
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 > 0) {
                stringBuffer.append(string2.substring(0, n3));
                stringBuffer.append(string);
                stringBuffer.append(string2.substring(n3));
            } else {
                stringBuffer.append("0");
                stringBuffer.append(string);
                while (n3++ < 0) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
            }
            string2 = stringBuffer.toString();
        }
        if ((this.hooks(25) || this.filters(25)) && (string2 = this.verifyText(string2, 0, n2 = OS.GetWindowTextLength((int)this.hwndText), null)) == null) {
            return;
        }
        string = new TCHAR(this.getCodePage(), string2, true);
        OS.SetWindowText((int)this.hwndText, (TCHAR)string);
        if (bl) {
            this.postEvent(13);
        }
    }

    void subclass() {
        super.subclass();
        int n = this.display.windowProc;
        OS.SetWindowLong((int)this.hwndText, (int)-4, (int)n);
        OS.SetWindowLong((int)this.hwndUpDown, (int)-4, (int)n);
    }

    void unsubclass() {
        super.unsubclass();
        OS.SetWindowLong((int)this.hwndText, (int)-4, (int)EditProc);
        OS.SetWindowLong((int)this.hwndUpDown, (int)-4, (int)UpDownProc);
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        int n3 = 0;
        if (this.digits > 0) {
            String string2 = this.getDecimalSeparator();
            n3 = string.indexOf(string2);
            if (n3 != -1) {
                string = string.substring(0, n3) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
            ++n3;
        }
        boolean bl = event2.doit = n3 == string.length();
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFFFFDFF;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        if (n == this.hwndText || n == this.hwndUpDown) {
            LRESULT lRESULT = null;
            switch (n2) {
                case 258: {
                    lRESULT = this.wmChar(n, n3, n4);
                    break;
                }
                case 646: {
                    lRESULT = this.wmIMEChar(n, n3, n4);
                    break;
                }
                case 256: {
                    lRESULT = this.wmKeyDown(n, n3, n4);
                    break;
                }
                case 257: {
                    lRESULT = this.wmKeyUp(n, n3, n4);
                    break;
                }
                case 262: {
                    lRESULT = this.wmSysChar(n, n3, n4);
                    break;
                }
                case 260: {
                    lRESULT = this.wmSysKeyDown(n, n3, n4);
                    break;
                }
                case 261: {
                    lRESULT = this.wmSysKeyUp(n, n3, n4);
                    break;
                }
                case 533: {
                    lRESULT = this.wmCaptureChanged(n, n3, n4);
                    break;
                }
                case 515: {
                    lRESULT = this.wmLButtonDblClk(n, n3, n4);
                    break;
                }
                case 513: {
                    lRESULT = this.wmLButtonDown(n, n3, n4);
                    break;
                }
                case 514: {
                    lRESULT = this.wmLButtonUp(n, n3, n4);
                    break;
                }
                case 521: {
                    lRESULT = this.wmMButtonDblClk(n, n3, n4);
                    break;
                }
                case 519: {
                    lRESULT = this.wmMButtonDown(n, n3, n4);
                    break;
                }
                case 520: {
                    lRESULT = this.wmMButtonUp(n, n3, n4);
                    break;
                }
                case 673: {
                    lRESULT = this.wmMouseHover(n, n3, n4);
                    break;
                }
                case 675: {
                    lRESULT = this.wmMouseLeave(n, n3, n4);
                    break;
                }
                case 512: {
                    lRESULT = this.wmMouseMove(n, n3, n4);
                    break;
                }
                case 518: {
                    lRESULT = this.wmRButtonDblClk(n, n3, n4);
                    break;
                }
                case 516: {
                    lRESULT = this.wmRButtonDown(n, n3, n4);
                    break;
                }
                case 517: {
                    lRESULT = this.wmRButtonUp(n, n3, n4);
                    break;
                }
                case 525: {
                    lRESULT = this.wmXButtonDblClk(n, n3, n4);
                    break;
                }
                case 523: {
                    lRESULT = this.wmXButtonDown(n, n3, n4);
                    break;
                }
                case 524: {
                    lRESULT = this.wmXButtonUp(n, n3, n4);
                    break;
                }
                case 7: {
                    lRESULT = this.wmSetFocus(n, n3, n4);
                    break;
                }
                case 8: {
                    lRESULT = this.wmKillFocus(n, n3, n4);
                    break;
                }
                case 15: {
                    lRESULT = this.wmPaint(n, n3, n4);
                    break;
                }
                case 123: {
                    lRESULT = this.wmContextMenu(n, n3, n4);
                    break;
                }
                case 199: 
                case 768: 
                case 770: 
                case 771: 
                case 772: {
                    if (n != this.hwndText) break;
                    lRESULT = this.wmClipboard(n, n2, n3, n4);
                }
            }
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(n, n2, n3, n4);
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.drawBackground(n);
        return LRESULT.ONE;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        return null;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        OS.SetFocus((int)this.hwndText);
        return null;
    }

    LRESULT WM_SETFONT(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFONT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.SendMessage((int)this.hwndText, (int)48, (int)n, (int)n2);
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n3 = n2 & 0xFFFF;
        int n4 = n2 >> 16;
        int n5 = OS.GetSystemMetrics((int)2);
        int n6 = n3 - n5;
        int n7 = 52;
        this.SetWindowPos(this.hwndText, 0, 0, 0, n6, n4, n7);
        this.SetWindowPos(this.hwndUpDown, 0, n6, 0, n5, n4, n7);
        return lRESULT;
    }

    LRESULT wmChar(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmChar(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 13: {
                int n4 = this.getSelectionText();
                this.setSelection(n4, true);
                this.postEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n, int n2, int n3, int n4) {
        if ((this.style & 8) != 0) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        String string2 = null;
        switch (n2) {
            case 768: 
            case 771: {
                OS.SendMessage((int)n, (int)176, (int[])nArray, (int[])nArray2);
                if (nArray[0] == nArray2[0]) break;
                string2 = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage((int)n, (int)176, (int[])nArray, (int[])nArray2);
                string2 = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage((int)n, (int)198, (int)0, (int)0) == 0) break;
                this.ignoreModify = true;
                OS.SendMessage((int)n, (int)176, (int[])nArray, (int[])nArray2);
                OS.CallWindowProc((int)EditProc, (int)n, (int)n2, (int)n3, (int)n4);
                int n5 = OS.GetWindowTextLength((int)n);
                if (n5 != 0 && nArray[0] != nArray2[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n5 + 1);
                    OS.GetWindowText((int)n, (TCHAR)tCHAR, (int)(n5 + 1));
                    string2 = tCHAR.toString(nArray[0], nArray2[0] - nArray[0]);
                } else {
                    string2 = "";
                }
                OS.CallWindowProc((int)EditProc, (int)n, (int)n2, (int)n3, (int)n4);
                this.ignoreModify = false;
            }
        }
        if (string2 != null && !string2.equals(string)) {
            string = string2;
            if ((string2 = this.verifyText(string2, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string2.equals(string)) {
                if (bl) {
                    OS.CallWindowProc((int)EditProc, (int)n, (int)n2, (int)n3, (int)n4);
                }
                TCHAR tCHAR = new TCHAR(this.getCodePage(), string2, true);
                if (n2 == 12) {
                    int n6 = OS.GetProcessHeap();
                    int n7 = tCHAR.length() * TCHAR.sizeof;
                    int n8 = OS.HeapAlloc((int)n6, (int)8, (int)n7);
                    OS.MoveMemory((int)n8, (TCHAR)tCHAR, (int)n7);
                    int n9 = OS.CallWindowProc((int)EditProc, (int)n, (int)n2, (int)n3, (int)n8);
                    OS.HeapFree((int)n6, (int)0, (int)n8);
                    return new LRESULT(n9);
                }
                OS.SendMessage((int)n, (int)194, (int)0, (TCHAR)tCHAR);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = n >> 16;
        switch (n3) {
            case 768: {
                if (this.ignoreModify) break;
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        UDACCEL uDACCEL = new UDACCEL();
        OS.SendMessage((int)this.hwndUpDown, (int)1132, (int)1, (UDACCEL)uDACCEL);
        int n4 = 0;
        switch (n2) {
            case 38: {
                n4 = uDACCEL.nInc;
                break;
            }
            case 40: {
                n4 = -uDACCEL.nInc;
                break;
            }
            case 33: {
                n4 = this.pageIncrement;
                break;
            }
            case 34: {
                n4 = -this.pageIncrement;
            }
        }
        if (n4 != 0) {
            int n5 = this.getSelectionText();
            int n6 = n5 + n4;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray2, (int[])nArray);
            if ((this.style & 0x40) != 0) {
                if (n6 < nArray2[0]) {
                    n6 = nArray[0];
                }
                if (n6 > nArray[0]) {
                    n6 = nArray2[0];
                }
            }
            if (n5 != (n6 = Math.min(Math.max(nArray2[0], n6), nArray[0]))) {
                this.setSelection(n6, true);
            }
        }
        switch (n2) {
            case 38: 
            case 40: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmKillFocus(int n, int n2, int n3) {
        int n4 = this.getSelectionText();
        this.setSelection(n4, true);
        return super.wmKillFocus(n, n2, n3);
    }

    LRESULT wmLButtonDown(int n, int n2, int n3) {
        if (n == this.hwndUpDown) {
            int n4 = this.getSelectionText();
            OS.SendMessage((int)this.hwndUpDown, (int)(OS.IsWinCE ? 1127 : 1137), (int)0, (int)n4);
        }
        return super.wmLButtonDown(n, n2, n3);
    }

    LRESULT wmNotifyChild(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory((NMHDR)nMHDR, (int)n2, (int)12);
        switch (nMHDR.code) {
            case -722: {
                NMUPDOWN nMUPDOWN = new NMUPDOWN();
                OS.MoveMemory((NMUPDOWN)nMUPDOWN, (int)n2, (int)20);
                int n3 = nMUPDOWN.iPos + nMUPDOWN.iDelta;
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage((int)this.hwndUpDown, (int)1136, (int[])nArray2, (int[])nArray);
                if ((this.style & 0x40) != 0) {
                    if (n3 < nArray2[0]) {
                        n3 = nArray[0];
                    }
                    if (n3 > nArray[0]) {
                        n3 = nArray2[0];
                    }
                }
                n3 = Math.min(Math.max(nArray2[0], n3), nArray[0]);
                this.setSelection(n3, true);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(n, n2);
    }

    LRESULT wmScrollChild(int n, int n2) {
        int n3 = n & 0xFFFF;
        switch (n3) {
            case 4: {
                this.postEvent(13);
            }
        }
        return super.wmScrollChild(n, n2);
    }

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        UpDownClass = new TCHAR(0, "msctls_updown32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo((int)0, (TCHAR)EditClass, (WNDCLASS)wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo((int)0, (TCHAR)UpDownClass, (WNDCLASS)wNDCLASS);
        UpDownProc = wNDCLASS.lpfnWndProc;
    }
}

