/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.unitarou.jface.ImageResource;

public class FileNameLabelProvider
extends LabelProvider {
    private static final ImageResource IMG_FOLDER = new ImageResource(FileNameLabelProvider.class, "folder.png");

    public Image getImage(Object object) {
        if (object instanceof File) {
            ImageData imageData;
            File file = (File)object;
            if (file.isDirectory()) {
                return IMG_FOLDER.get();
            }
            String string = FilenameUtils.getExtension((String)file.getPath());
            Image image = ImageResource.get(FileNameLabelProvider.class, string);
            if (image != null) {
                return image;
            }
            Program program = Program.findProgram((String)string);
            if (program != null && (imageData = program.getImageData()) != null) {
                ImageResource.put(FileNameLabelProvider.class, string, imageData);
                return ImageResource.get(FileNameLabelProvider.class, string);
            }
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            return file.getName();
        }
        return super.getText(object);
    }
}

