/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileNameLabelProvider;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderTreeContentProvider;
import org.unitarou.jface.ImageResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

public class FolderTreeViewer
implements WidgetContainer {
    private static final ImageResource IMG_UP_NAVI = new ImageResource(FolderTreeViewer.class, "upNavi.png");
    private static final ImageResource IMG_UP_NAVI_D = new ImageResource(FolderTreeViewer.class, "upNaviD.png");
    private static final ImageResource IMG_DOWN_NAVI = new ImageResource(FolderTreeViewer.class, "downNavi.png");
    private static final ImageResource IMG_DOWN_NAVI_D = new ImageResource(FolderTreeViewer.class, "downNaviD.png");
    private static final ImageResource IMG_DRIVE = new ImageResource(FolderTreeViewer.class, "drive.png");
    private static final MessageResource NT_TT_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "ntTtChangedrive");
    private static final MessageResource NT_TT_UPFOLDER = new MessageResource(FolderTreeViewer.class, "ntTtUpfolder");
    private static final MessageResource NT_TT_DOWNFOLDER = new MessageResource(FolderTreeViewer.class, "ntTtDownfolder");
    private static final MessageResource NT_TITLE_FAILURE_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "ntTitleFailureChangedrive");
    private static final MessageResource MSG_FAILURE_CHANGEDRIVE = new MessageResource(FolderTreeViewer.class, "msgFailureChangedrive");
    private File root_ = new File(".").getAbsoluteFile().getParentFile();
    private Composite frame_;
    private ToolItem tiRoots_ = null;
    private ToolItem tiUpNavi_ = null;
    private ToolItem tiDownNavi_ = null;
    private final DownNaviSelectionListener listener_ = new DownNaviSelectionListener();
    private CLabel clbRoot_ = null;
    private TreeViewer treeViewer_ = null;
    private final Set<FolderListener> listeners_ = new HashSet<FolderListener>();
    private File folder_ = this.root_;

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout((Layout)new GridLayout(1, false));
        final ToolBar toolBar = new ToolBar(this.frame_, 0x800000);
        final Menu menu = this.createRootsMenu(composite.getShell());
        final ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setToolTipText(NT_TT_CHANGEDRIVE.get());
        toolItem.setImage(IMG_DRIVE.get());
        toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rectangle = toolItem.getBounds();
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    point = toolBar.toDisplay(point);
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                }
            }
        });
        this.tiUpNavi_ = new ToolItem(toolBar, 8);
        this.tiUpNavi_.setImage(IMG_UP_NAVI.get());
        this.tiUpNavi_.setDisabledImage(IMG_UP_NAVI_D.get());
        this.tiUpNavi_.addSelectionListener((SelectionListener)new UpNaviSelectionListener());
        this.tiDownNavi_ = new ToolItem(toolBar, 8);
        this.tiDownNavi_.setImage(IMG_DOWN_NAVI.get());
        this.tiDownNavi_.setDisabledImage(IMG_DOWN_NAVI_D.get());
        this.tiDownNavi_.addSelectionListener((SelectionListener)this.listener_);
        this.tiDownNavi_.setEnabled(false);
        toolBar.pack();
        this.clbRoot_ = new CLabel(this.frame_, 16384);
        this.clbRoot_.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.treeViewer_ = new TreeViewer(this.frame_, 2820);
        this.treeViewer_.setContentProvider((IContentProvider)new FolderTreeContentProvider());
        this.treeViewer_.setLabelProvider((IBaseLabelProvider)new FileNameLabelProvider());
        this.treeViewer_.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer_.addPostSelectionChangedListener((ISelectionChangedListener)this.listener_);
        this.rootChanted();
        return this.frame_;
    }

    private Menu createRootsMenu(Shell shell) {
        RootsSelectionListener rootsSelectionListener = new RootsSelectionListener();
        Menu menu = new Menu((Decorations)shell, 8);
        for (File file : File.listRoots()) {
            MenuItem menuItem = new MenuItem(menu, 16);
            menuItem.setText(file.getPath());
            menuItem.setData((Object)file);
            menuItem.setImage(IMG_DRIVE.get());
            menuItem.addSelectionListener((SelectionListener)rootsSelectionListener);
            if (!this.root_.getPath().startsWith(file.getPath())) continue;
            menuItem.setSelection(true);
        }
        return menu;
    }

    private void rootChanted() {
        this.clbRoot_.setText(this.root_.getPath());
        if (this.treeViewer_ != null) {
            this.treeViewer_.setInput((Object)this.root_);
            this.treeViewer_.setSelection((ISelection)new StructuredSelection((Object)this.folder_), true);
        }
        this.tiUpNavi_.setEnabled(this.root_.getParentFile() != null);
        if (this.tiUpNavi_.isEnabled()) {
            this.tiUpNavi_.setToolTipText(NT_TT_UPFOLDER.get((Object)this.root_.getParent()));
        }
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.frame_;
    }

    public File getRoot() {
        return this.root_;
    }

    public File getFolder() {
        return this.folder_;
    }

    public void setRoot(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter must be a directory: " + file.getPath());
        }
        this.root_ = file;
        if (!Ios.isChild(this.root_, this.folder_)) {
            this.folder_ = this.root_;
        }
        this.rootChanted();
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter must be a directory: " + file.getPath());
        }
        this.folder_ = file;
        String string = Ios.calcCommonRoot(this.root_, this.folder_);
        this.root_ = string != null ? new File(string) : this.folder_;
        this.rootChanted();
    }

    public void addListener(FolderListener folderListener) {
        if (folderListener == null) {
            return;
        }
        this.listeners_.add(folderListener);
    }

    public void removeListener(FolderListener folderListener) {
        this.listeners_.remove(folderListener);
    }

    private class DownNaviSelectionListener
    extends SelectionAdapter
    implements ISelectionChangedListener {
        private DownNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (FolderTreeViewer.this.folder_ != null && FolderTreeViewer.this.folder_.getParentFile() != null) {
                FolderTreeViewer.this.root_ = FolderTreeViewer.this.folder_.getParentFile();
                FolderTreeViewer.this.rootChanted();
            }
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
            File file = (File)iStructuredSelection.getFirstElement();
            if (file == null || !file.canRead()) {
                FolderTreeViewer.this.tiDownNavi_.setEnabled(false);
                return;
            }
            FolderTreeViewer.this.folder_ = file;
            boolean bl = false;
            for (File file2 : FolderTreeViewer.this.folder_.listFiles()) {
                if (!file2.isDirectory()) continue;
                bl = true;
                break;
            }
            FolderTreeViewer.this.tiDownNavi_.setEnabled(bl);
            if (bl) {
                FolderTreeViewer.this.tiDownNavi_.setToolTipText(NT_TT_DOWNFOLDER.get((Object)FolderTreeViewer.this.folder_.getName()));
            }
            for (FolderListener folderListener : FolderTreeViewer.this.listeners_) {
                folderListener.folderChanged(FolderTreeViewer.this.folder_);
            }
        }
    }

    private class UpNaviSelectionListener
    extends SelectionAdapter {
        private UpNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            FolderTreeViewer.this.root_ = FolderTreeViewer.this.root_.getParentFile();
            FolderTreeViewer.this.rootChanted();
        }
    }

    private class RootsSelectionListener
    extends SelectionAdapter {
        private RootsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            File file = (File)selectionEvent.widget.getData();
            if (file.canRead()) {
                FolderTreeViewer.this.root_ = file;
                FolderTreeViewer.this.rootChanted();
                return;
            }
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            menuItem.setSelection(false);
            Menu menu = menuItem.getParent();
            for (MenuItem menuItem2 : menu.getItems()) {
                if (!menuItem2.getData().equals(FolderTreeViewer.this.root_)) continue;
                menuItem2.setSelection(true);
                break;
            }
            MessageDialog.openWarning((Shell)FolderTreeViewer.this.clbRoot_.getShell(), (String)NT_TITLE_FAILURE_CHANGEDRIVE.get(), (String)MSG_FAILURE_CHANGEDRIVE.get((Object)file.getPath()));
        }
    }
}

