/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.nio.charset.Charset;
import java.text.StringCharacterIterator;
import org.unitarou.util.ArgumentChecker;

public class Strings {
    public static final String EMPTY = "";
    public static final String NULL_MARK = "<<null>>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Charset CHARSET_US_ASCII = Charset.forName("US-ASCII");

    public static boolean equalsIgnoreEolType(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringCharacterIterator stringCharacterIterator2 = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        char c2 = stringCharacterIterator2.first();
        while (true) {
            if (c == '\r' && (c = stringCharacterIterator.next()) != '\n') {
                c = stringCharacterIterator.previous();
            }
            if (c2 == '\r' && (c2 = stringCharacterIterator2.next()) != '\n') {
                c2 = stringCharacterIterator2.previous();
            }
            if (!(c != '\r' && c != '\n' || c2 != '\r' && c2 != '\n')) {
                c = stringCharacterIterator.next();
                c2 = stringCharacterIterator2.next();
                continue;
            }
            if (c != c2) break;
            if (c == '\uffff') {
                return true;
            }
            c = stringCharacterIterator.next();
            c2 = stringCharacterIterator2.next();
        }
        return false;
    }

    public static boolean isUppercaseRomanAlphabet(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static String formatDuration(int n) {
        int n2 = n / 60;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2).append(':');
        if ((n %= 60) < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    public static String nullToNullMark(String string) {
        return string != null ? string : NULL_MARK;
    }

    public static int calcDiffSize(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        return Math.max(string.length(), string2.length()) - Strings.calcLscLength(string, string2);
    }

    public static int calcLscLength(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        if (string.length() == 0 || string2.length() == 0) {
            return 0;
        }
        int[][] nArray = new int[string.length() + 1][string2.length() + 1];
        int n = 0;
        for (int i = 1; i < nArray.length; ++i) {
            for (int j = 1; j < nArray[i].length; ++j) {
                nArray[i][j] = string.charAt(i - 1) == string2.charAt(j - 1) ? nArray[i - 1][j - 1] + 1 : Math.max(nArray[i - 1][j], nArray[i][j - 1]);
                n = Math.max(n, nArray[i][j]);
            }
        }
        return n;
    }

    protected Strings() {
    }
}

