/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Classes;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UEnum
implements Comparable {
    private static final Log log_s_ = LogFactory.getLog(UEnum.class);
    private static final Map<Class<? extends UEnum>, Map<Comparable<?>, UEnum>> enumMap_s_ = new HashMap();
    private static final char SEPARATOR = ':';
    private final Comparable typeName_;
    private final int hashCode_;

    public static UEnum find(Class<? extends UEnum> clazz, Comparable comparable) {
        ArgumentChecker.throwIfNull(clazz, (Object)comparable);
        Map<Comparable<?>, UEnum> map = UEnum.getMapWithLoad(clazz, "UEnum#find");
        if (map != null) {
            return map.get(comparable);
        }
        return null;
    }

    public static UEnum[] getAll(Class<? extends UEnum> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        Map<Comparable<?>, UEnum> map = UEnum.getMapWithLoad(clazz, "UEnum#getAll");
        return map == null ? new UEnum[]{} : map.values().toArray(new UEnum[map.size()]);
    }

    private static Map<Comparable<?>, UEnum> getMapWithLoad(Class<? extends UEnum> clazz, String string) {
        Map<Comparable<?>, UEnum> map = enumMap_s_.get(clazz);
        if (map == null) {
            try {
                Class.forName(clazz.getName());
                log_s_.debug((Object)("Load " + clazz.getName() + " by " + string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log_s_.error((Object)("Class load failure: " + clazz.getName()), (Throwable)classNotFoundException);
            }
            map = enumMap_s_.get(clazz);
        }
        return map;
    }

    protected UEnum(Comparable comparable) {
        ArgumentChecker.throwIfNull((Object)comparable);
        this.typeName_ = comparable;
        Map<Comparable<?>, UEnum> map = enumMap_s_.get(this.getClass());
        if (map == null) {
            map = new TreeMap();
            enumMap_s_.put(this.getClass(), map);
        } else if (map.containsKey(this.typeName_)) {
            throw new IllegalArgumentException(comparable + "[" + this.getClass().getName() + "] has already registered.");
        }
        this.hashCode_ = this.typeName_.hashCode();
        map.put(this.typeName_, this);
    }

    public Comparable typeName() {
        return this.typeName_;
    }

    public String toString() {
        return Classes.simpleName(this.getClass()) + ':' + this.typeName_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return this.typeName_.equals(((UEnum)object).typeName_);
    }

    public int hashCode() {
        return this.hashCode_;
    }

    public int compareTo(Object object) {
        return this.typeName_.compareTo(((UEnum)object).typeName_);
    }
}

