/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.unitarou.sgf.Node;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sequence
implements Iterable<Node> {
    private final List<Node> nodes_;

    public Sequence() {
        this.nodes_ = new ArrayList<Node>();
    }

    public Sequence(Sequence sequence) {
        ArgumentChecker.throwIfNull((Object)sequence);
        this.nodes_ = new ArrayList<Node>(sequence.nodes_);
    }

    public void addFirst(Node node) {
        this.nodes_.add(0, node);
    }

    public void addLast(Node node) {
        this.nodes_.add(node);
    }

    public void insert(Node node, Node node2) {
        ArgumentChecker.throwIfNull((Object)node2);
        int n = this.nodes_.indexOf(node2);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.nodes_.add(n, node);
    }

    public void addAll(Sequence sequence) {
        ArgumentChecker.throwIfNull((Object)sequence);
        this.nodes_.addAll(sequence.nodes_);
    }

    public boolean remove(Node node) {
        return this.nodes_.remove(node);
    }

    public Node removeLast() {
        return 0 < this.nodes_.size() ? this.nodes_.remove(this.nodes_.size() - 1) : null;
    }

    public void clear() {
        this.nodes_.clear();
    }

    public boolean isEmpty() {
        return this.nodes_.isEmpty();
    }

    public int size() {
        return this.nodes_.size();
    }

    public Node getFirst() {
        return this.nodes_.get(0);
    }

    public Node getLast() {
        return 0 < this.nodes_.size() ? this.nodes_.get(this.nodes_.size() - 1) : null;
    }

    public Node[] getNodes() {
        return this.nodes_.toArray(new Node[this.nodes_.size()]);
    }

    public Iterator iterator() {
        return new Iterator(this.nodes_);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Sequence sequence = (Sequence)object;
        return ((Object)this.nodes_).equals(sequence.nodes_);
    }

    public int hashCode() {
        int n = this.nodes_.size() * 133;
        if (this.nodes_.size() != 0) {
            n += this.nodes_.get(0).hashCode();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<Node> {
        private final ListIterator<Node> iterator_;

        private Iterator(List<Node> list) {
            this.iterator_ = list.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public Node next() {
            return this.iterator_.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

