/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf;

import java.io.File;
import java.text.StringCharacterIterator;
import org.unitarou.sgf.GameTree;
import org.unitarou.util.ArgumentChecker;

public final class Sgfs {
    public static final char GAME_TREE_START_MARK = '(';
    public static final char GAME_TREE_END_MARK = ')';
    public static final char NODE_START_MARK = ';';
    public static final char VALUE_START_MARK = '[';
    public static final char VALUE_END_MARK = ']';
    public static final char ESCAPE_SOFT_LINE_BREAK = '\\';
    public static final char COMPOSE_SEPARATOR = ':';
    public static final int ST_CHILDLEN = 0;
    public static final int ST_SIBLINGS = 1;
    public static final char IF_FILE_SEPARATOR_ESCAPE_MARK = '/';
    public static final String EXTENSION = "sgf";

    public static CharSequence unespaceForRead(CharSequence charSequence) {
        ArgumentChecker.throwIfNull((Object)charSequence);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            c = Sgfs.next(charSequence, i);
            if (c == '\uffff') break;
            ++i;
            if ('\r' == c) {
                c = Sgfs.next(charSequence, i);
                if (c == '\uffff') break;
                ++i;
                if ('\n' == c) continue;
                stringBuilder.append(c);
                continue;
            }
            if ('\n' == c) {
                c = Sgfs.next(charSequence, i);
                if (c == '\uffff') break;
                ++i;
                if ('\r' == c) continue;
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    private static char next(CharSequence charSequence, int n) {
        return 0 <= n && n + 1 < charSequence.length() ? charSequence.charAt(n + 1) : (char)'\uffff';
    }

    public static String unescapeTextForRead(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c != '\\') {
                if (c == '\r' || c == '\n' || !Character.isWhitespace(c)) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(' ');
                }
            } else {
                c = stringCharacterIterator.next();
                if ('\r' == c) {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') break;
                    if ('\n' != c) {
                        stringBuilder.append(c);
                    }
                } else if ('\n' == c) {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') break;
                    if ('\r' != c) {
                        stringBuilder.append(c);
                    }
                } else {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static String unescapeSimpleTextForRead(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c != '\\') {
                if (!Character.isWhitespace(c)) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(' ');
                }
            } else {
                c = stringCharacterIterator.next();
                if ('\r' == c) {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') break;
                    if ('\n' != c) {
                        stringBuilder.append(c);
                    }
                } else if ('\n' == c) {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') break;
                    if ('\r' != c) {
                        stringBuilder.append(c);
                    }
                } else {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static String escapeForStore(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case ']': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    break;
                }
                case '\\': {
                    char c2 = stringCharacterIterator.next();
                    if (c2 != '\n' && c2 != '\r') {
                        stringBuilder.append('\\');
                    }
                    stringCharacterIterator.previous();
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static String unescapeIfForRead(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return string.replace('/', File.separatorChar);
    }

    public static String escapeIfForStore(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return Sgfs.escapeForStore(string.replace(File.separatorChar, '/'));
    }

    public static boolean isValidId(String string) {
        if (string == null || string.length() == 0 || 2 < string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && 'Z' >= c) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidEntireId(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z') {
                bl = true;
                continue;
            }
            if (c >= 'a' && 'z' >= c) continue;
            return false;
        }
        return bl;
    }

    public static String convertRegularId(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('A' > c || c > 'Z') continue;
            stringBuilder.append(c);
            if (stringBuilder.length() == 2) break;
        }
        assert (0 < stringBuilder.length() && stringBuilder.length() <= 2);
        return stringBuilder.toString();
    }

    public static int fromSgf(char c) {
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            return c <= 'Z' ? c - 65 + 27 : c - 97 + 1;
        }
        throw new IllegalArgumentException("c is out of range: " + c);
    }

    public static char toSgf(int n) {
        if (n <= 0 || 52 < n) {
            throw new IllegalArgumentException("position is out of range:" + n);
        }
        return n <= 26 ? (char)(97 + n - 1) : (char)(65 + n - 27);
    }

    public static GameTree getRoot(GameTree gameTree) {
        ArgumentChecker.throwIfNull((Object)gameTree);
        GameTree gameTree2 = gameTree;
        while (gameTree2.getParent() != null) {
            gameTree2 = gameTree2.getParent();
        }
        return gameTree2;
    }
}

