/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.io.dl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.io.dl.DefaultHttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloadEvent;

public class Board2chDownloader
extends DefaultHttpDownloader {
    private static final MessageResource LB_NAME = new MessageResource(Board2chDownloader.class, "lbName");
    private static final MessageResource LB_STATUS_EXTRACT_RES = new MessageResource(Board2chDownloader.class, "lbStatusExtractRes");
    private static final MessageResource LB_STATUS_REPLACE_A_TAG = new MessageResource(Board2chDownloader.class, "lbStatusReplaceATag");
    private static final Pattern patternRes_s_ = Pattern.compile("<dd>(.*)$", 8);
    private static final Pattern patternATag_s_ = Pattern.compile("<a.*>(.*)</a>");
    private static final Pattern patternUrl_s_ = Pattern.compile("http://\\w+\\.2ch\\.net/");

    public String displayName() {
        return LB_NAME.get();
    }

    protected CharSequence findSgf(CharSequence charSequence) {
        this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_EXTRACT_RES.get(), 20));
        Matcher matcher = patternRes_s_.matcher(charSequence);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        while (matcher.find()) {
            stringBuilder.append(matcher.group(1));
        }
        return stringBuilder.toString();
    }

    protected CharSequence replaceHtmlElements(CharSequence charSequence) {
        charSequence = super.replaceHtmlElements(charSequence);
        this.notifyListener(new HttpDownloadEvent(this, LB_STATUS_REPLACE_A_TAG.get(), 20));
        charSequence = patternATag_s_.matcher(charSequence).replaceAll("$1");
        return charSequence;
    }

    public int matches(String string) {
        return patternUrl_s_.matcher(string).find() ? 10 : -10;
    }
}

