/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.SimpleText;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class Label
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(Label.class);
    private static final Pattern condition_s_ = Pattern.compile("([a-zA-Z]{2})\\s*:(.*)");
    private static final int POSITION_POS = 1;
    private static final int LABEL_POS = 2;
    private final SgfPoint point_;
    private final SimpleText label_;

    public static String[] parseString(String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value='" + string + '\'');
        }
        return new String[]{matcher.group(1), matcher.group(2)};
    }

    public static Label parse(SgfSize sgfSize, String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)string);
        String[] stringArray = Label.parseString(string);
        return new Label(SgfPoint.parseMove(sgfSize, stringArray[0]), SimpleText.parse(stringArray[1]));
    }

    public static Label parseQuietly(SgfSize sgfSize, String string) {
        try {
            return Label.parse(sgfSize, string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug((Object)("Bad value for parse: " + string), (Throwable)typeParseException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log_s_.debug((Object)("Bad value for parse: " + string), (Throwable)illegalArgumentException);
            return null;
        }
    }

    public Label(SgfPoint sgfPoint, SimpleText simpleText) {
        this.point_ = sgfPoint;
        this.label_ = simpleText;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.LABEL.equals(sgfId);
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.point_.getString());
        stringBuilder.append(':');
        stringBuilder.append(this.label_.getString());
        return stringBuilder.toString();
    }

    public SgfPoint getPoint() {
        return this.point_;
    }

    public SimpleText getLabel() {
        return this.label_;
    }

    public boolean isValid(String string) {
        return string != null ? condition_s_.matcher(string).matches() : false;
    }

    public int compareTo(Object object) {
        Label label = (Label)object;
        return this.point_.compareTo(label.point_);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Label)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Label label = (Label)object;
        return this.point_.equals(label.point_);
    }

    public int hashCode() {
        return this.point_.hashCode();
    }
}

