/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.util.ArgumentChecker;

public class ProblemProperties
extends SgfNumber {
    private static final Log log_s_ = LogFactory.getLog(ProblemProperties.class);
    private static final Pattern condition_s_ = Pattern.compile("\\d+");
    private final EnumSet<Flag> enumSet_;

    public static ProblemProperties parsePp(String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)string);
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        return new ProblemProperties(Integer.parseInt(matcher.group()));
    }

    public static ProblemProperties parsePpQuietly(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            return ProblemProperties.parsePp(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug((Object)("Unknown value for ProblemProperties: " + string), (Throwable)typeParseException);
            return new ProblemProperties(0);
        }
    }

    public ProblemProperties(int n) {
        super(n);
        this.enumSet_ = EnumSet.noneOf(Flag.class);
        EnumSet<Flag> enumSet = EnumSet.allOf(Flag.class);
        for (Flag flag : enumSet) {
            if ((flag.value_ & n) == 0) continue;
            this.enumSet_.add(flag);
        }
    }

    public ProblemProperties(Flag ... flagArray) {
        super(Flag.toIntValue(flagArray));
        this.enumSet_ = EnumSet.copyOf(Arrays.asList(flagArray));
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.PROBLEM_PROPERTIES.equals(sgfId);
    }

    public boolean contains(Flag flag) {
        ArgumentChecker.throwIfNull((Object)flag);
        return this.enumSet_.contains((Object)flag);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        SHOW_HINT(1),
        SHUFFLE(2),
        RETRYABLE(4),
        TIME_LIMIT(8),
        MIRROR_ROTATE(16),
        SHOW_ENDPOINT(32);

        private final int value_;
        private final MessageResource messageResource_;

        public static int toIntValue(Flag ... flagArray) {
            int n = 0;
            for (Flag flag : flagArray) {
                n |= flag.value_;
            }
            return n;
        }

        private Flag(int n2) {
            this.value_ = n2;
            this.messageResource_ = new MessageResource(((Object)((Object)this)).getClass(), String.valueOf(n2));
        }

        public int getValue() {
            return this.value_;
        }

        public String getDisplayName() {
            return this.messageResource_.get();
        }
    }
}

