/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfSize
implements TypedString {
    public static final int MAX_LENGTH = 52;
    public static final int OLD_PASS_POS = 20;
    private static final Pattern condition_s_ = Pattern.compile("(\\d{1,2})((\\s*:\\s*)(\\d{1,2}))?");
    private static final int WIDTH_POS = 1;
    private static final int HEIGHT_POS = 4;
    private static final int DEFAULT_WIDTH = 19;
    private static final int DEFAULT_HEIGHT = 19;
    private static final SortedMap<Integer, SgfSize> cache_s_ = new TreeMap<Integer, SgfSize>();
    public static final SgfSize DEFAULT = SgfSize.create(19, 19);
    public static final SgfSize MAX = SgfSize.create(52, 52);
    private final int width_;
    private final int height_;
    private final SgfPoint[] allPoints_;
    private Set<SgfPoint> all_;
    private final SgfPoint passPoint_;
    private Integer primaryKey_;
    private String toString_;

    public static SgfSize parse(String string) throws TypeParseException {
        if (string == null) {
            throw new NullArgumentException("vaule must not be null.");
        }
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        int n = Integer.parseInt(matcher.group(1));
        String string2 = matcher.group(4);
        int n2 = string2 != null ? Integer.parseInt(string2) : n;
        return SgfSize.create(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SgfSize create(int n, int n2) {
        if (n < 1 || 52 < n || n2 < 1 || 52 < n2) {
            throw new IllegalArgumentException();
        }
        Integer n3 = new Integer(n + n2 * 52);
        SortedMap<Integer, SgfSize> sortedMap = cache_s_;
        synchronized (sortedMap) {
            SgfSize sgfSize = (SgfSize)cache_s_.get(n3);
            if (sgfSize == null) {
                sgfSize = new SgfSize(n, n2);
                cache_s_.put(n3, sgfSize);
            }
            return sgfSize;
        }
    }

    private SgfSize(int n, int n2) {
        assert (1 <= n && n <= 52 && 1 <= n2 && n2 <= 52);
        this.width_ = n;
        this.height_ = n2;
        this.allPoints_ = new SgfPoint[n * n2];
        this.all_ = null;
        int n3 = this.height_ < 20 && this.width_ < 20 ? 20 : 0;
        this.passPoint_ = new SgfPoint(this, n3, n3);
        this.primaryKey_ = null;
        this.toString_ = null;
    }

    public int width() {
        return this.width_;
    }

    public int height() {
        return this.height_;
    }

    SgfPoint get(int n, int n2) {
        SgfPointType sgfPointType = this.check(n, n2);
        if (sgfPointType == SgfPointType.OUT) {
            throw new IllegalArgumentException("You cannot create a point in outside of board.[Size:" + this + " x:" + n + " y:" + n2 + "]");
        }
        if (sgfPointType == SgfPointType.PASS) {
            return this.passPoint_;
        }
        int n3 = n - 1 + (n2 - 1) * this.height_;
        SgfPoint sgfPoint = this.allPoints_[n3];
        if (sgfPoint == null) {
            this.allPoints_[n3] = sgfPoint = new SgfPoint(this, n, n2);
        }
        return sgfPoint;
    }

    SgfPoint getPass() {
        return this.passPoint_;
    }

    public Set<SgfPoint> all() {
        if (this.all_ == null) {
            this.createAll();
            this.all_ = new HashSet<SgfPoint>(Arrays.asList(this.allPoints_));
        }
        return this.all_;
    }

    private void createAll() {
        for (int i = 0; i < this.width_; ++i) {
            for (int j = 0; j < this.height_; ++j) {
                int n = i + j * this.height_;
                if (this.allPoints_[n] != null) continue;
                this.allPoints_[n] = new SgfPoint(this, i + 1, j + 1);
            }
        }
    }

    public SgfPointType check(int n, int n2) {
        if (0 < n && n <= this.width_ && 0 < n2 && n2 <= this.height_) {
            return SgfPointType.IN;
        }
        if (n == 0 && n2 == 0 || n == 20 && n2 == 20 && this.width_ < 20 && this.height_ < 20) {
            return SgfPointType.PASS;
        }
        return SgfPointType.OUT;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.SIZE);
    }

    @Override
    public String getString() {
        if (this.width_ == this.height_) {
            return String.valueOf(this.width_);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.width_);
        stringBuilder.append(':');
        stringBuilder.append(this.height_);
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Object object) {
        SgfSize sgfSize = (SgfSize)object;
        return this.width_ + this.height_ * 52 - (sgfSize.width_ + sgfSize.height_ * 52);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SgfSize)) {
            return false;
        }
        SgfSize sgfSize = (SgfSize)object;
        return this.height_ == sgfSize.height_ && this.width_ == sgfSize.width_;
    }

    public int hashCode() {
        return this.primaryKey();
    }

    public int primaryKey() {
        if (this.primaryKey_ == null) {
            this.primaryKey_ = new Integer(this.height_ * 52 + this.width_);
        }
        return this.primaryKey_;
    }

    public String toString() {
        if (this.toString_ == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            stringBuilder.append(this.width_);
            stringBuilder.append(',');
            stringBuilder.append(this.height_);
            stringBuilder.append(')');
            this.toString_ = stringBuilder.toString();
        }
        return this.toString_;
    }

    public boolean isStarPoint(SgfPoint sgfPoint) {
        if (this.width_ % 2 + this.height_ % 2 == 2 && sgfPoint.x() == this.width_ / 2 + 1 && sgfPoint.y() == this.height_ / 2 + 1) {
            return true;
        }
        int n = sgfPoint.x();
        int n2 = sgfPoint.y();
        if (n > this.width_ / 2) {
            n = this.width_ - n + 1;
        }
        if (n2 > this.height_ / 2) {
            n2 = this.height_ - n2 + 1;
        }
        if (this.width_ >= 13 && this.height_ >= 13 && n == n2 && n == 4) {
            return true;
        }
        if (this.width_ >= 19 && sgfPoint.x() == this.width_ / 2 + 1 && n2 == 4) {
            return true;
        }
        return this.height_ >= 19 && sgfPoint.y() == this.height_ / 2 + 1 && n == 4;
    }
}

