/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.nio.charset.Charset;
import java.util.HashSet;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.util.ArgumentChecker;

public class RootGameTreeFactory {
    public static RootGameTree createGame(SgfSize sgfSize, Handicap handicap) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)handicap);
        RootGameTree rootGameTree = new RootGameTree();
        rootGameTree.setSize(sgfSize);
        rootGameTree.setFileFormat(FileFormat.VERSION_4);
        rootGameTree.setCharset(new SgfCharset(Charset.defaultCharset()));
        rootGameTree.setGameMode(GameMode.IGO);
        rootGameTree.setGameType(GameType.GAME);
        rootGameTree.setStyle(Style.SIBLINGS_SHOW_VAL);
        Node node = rootGameTree.getSequence().getFirst();
        node.addProperty(SgfId.HANDICAP.makeProperty(handicap));
        node.addProperty(SgfId.PLAYER_TO_PLAY.makeProperty(1 < handicap.getIntValue() ? SgfColor.WHITE : SgfColor.BLACK));
        SgfPoint[] sgfPointArray = RootGameTreeFactory.composeHandicapStone(sgfSize, handicap);
        if (sgfPointArray.length != 0) {
            node.addProperty(SgfId.ADD_BLACK.makeProperty(sgfPointArray));
        }
        return rootGameTree;
    }

    private static SgfPoint[] composeHandicapStone(SgfSize sgfSize, Handicap handicap) {
        int n = handicap.getIntValue();
        if (n < 2) {
            return new SgfPoint[0];
        }
        if (sgfSize.width() != sgfSize.height()) {
            throw new IllegalArgumentException();
        }
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(9);
        int n2 = sgfSize.width();
        int n3 = n2 + 1;
        int n4 = n2 + 1;
        int n5 = n2 + 1;
        if (n2 < 9) {
            n3 = n2 / 5 + 1;
            n5 = n2 - n3 + 1;
            n4 = n2 / 2 + 1;
        } else if (n2 < 13) {
            n3 = 3;
            n5 = n2 - n3 + 1;
            n4 = n2 / 2 + 1;
        } else {
            n3 = 4;
            n5 = n2 - n3 + 1;
            n4 = n2 / 2 + 1;
        }
        switch (n) {
            case 9: {
                hashSet.add(SgfPoint.create(sgfSize, n4, n3));
                hashSet.add(SgfPoint.create(sgfSize, n4, n5));
            }
            case 7: {
                hashSet.add(SgfPoint.create(sgfSize, n5, n4));
                hashSet.add(SgfPoint.create(sgfSize, n3, n4));
            }
            case 5: {
                hashSet.add(SgfPoint.create(sgfSize, n4, n4));
            }
            case 4: {
                hashSet.add(SgfPoint.create(sgfSize, n5, n5));
            }
            case 3: {
                hashSet.add(SgfPoint.create(sgfSize, n3, n3));
            }
            case 2: {
                hashSet.add(SgfPoint.create(sgfSize, n5, n3));
                hashSet.add(SgfPoint.create(sgfSize, n3, n5));
                break;
            }
            case 8: {
                hashSet.add(SgfPoint.create(sgfSize, n4, n3));
                hashSet.add(SgfPoint.create(sgfSize, n4, n5));
            }
            case 6: {
                hashSet.add(SgfPoint.create(sgfSize, n5, n4));
                hashSet.add(SgfPoint.create(sgfSize, n3, n4));
                hashSet.add(SgfPoint.create(sgfSize, n5, n5));
                hashSet.add(SgfPoint.create(sgfSize, n3, n3));
                hashSet.add(SgfPoint.create(sgfSize, n5, n3));
                hashSet.add(SgfPoint.create(sgfSize, n3, n5));
            }
        }
        return hashSet.toArray(new SgfPoint[hashSet.size()]);
    }

    public static RootGameTree createProblem(SgfSize sgfSize, SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)sgfColor);
        RootGameTree rootGameTree = new RootGameTree();
        rootGameTree.setSize(sgfSize);
        rootGameTree.setFileFormat(FileFormat.VERSION_4);
        rootGameTree.setCharset(new SgfCharset(Charset.defaultCharset()));
        rootGameTree.setGameMode(GameMode.IGO);
        rootGameTree.setGameType(GameType.PROBLEM);
        rootGameTree.setStyle(Style.SIBLINGS_SHOW_VAL);
        Node node = rootGameTree.getSequence().getFirst();
        node.addProperty(SgfId.PLAYER_TO_PLAY.makeProperty(sgfColor));
        return rootGameTree;
    }

    public static RootGameTree createDrill() {
        RootGameTree rootGameTree = new RootGameTree();
        rootGameTree.setFileFormat(FileFormat.VERSION_4);
        rootGameTree.setCharset(new SgfCharset(Charset.defaultCharset()));
        rootGameTree.setGameMode(GameMode.IGO);
        rootGameTree.setGameType(GameType.DRILL);
        Node node = new Node();
        node.addProperty(SgfId.PROBLEM_PROPERTIES.makeProperty(new ProblemProperties(ProblemProperties.Flag.RETRYABLE)));
        rootGameTree.getSequence().addLast(node);
        return rootGameTree;
    }

    protected RootGameTreeFactory() {
    }
}

