/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.IdentityHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sgfs;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfArgumentChecker {
    private static final Log logInspect_s_ = LogFactory.getLog((String)(SgfArgumentChecker.class.getName() + ".INSPECT"));

    public static void throwIfNotAChild(Node node, GameTree gameTree) {
        if (!logInspect_s_.isDebugEnabled()) {
            return;
        }
        ArgumentChecker.throwIfNull((Object)node, (Object)gameTree);
        for (Node node2 : gameTree.getSequence()) {
            if (node2 != node) continue;
            return;
        }
        throw new IllegalArgumentException(node + " is not a child of " + gameTree);
    }

    public static void throwIfInvalid(RootGameTree rootGameTree) {
        if (!logInspect_s_.isDebugEnabled()) {
            return;
        }
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        IdentityHashMap<GameTree, Object> identityHashMap = new IdentityHashMap<GameTree, Object>();
        IdentityHashMap<Node, Object> identityHashMap2 = new IdentityHashMap<Node, Object>();
        SgfArgumentChecker.throwIfInvalidImpl(identityHashMap, identityHashMap2, rootGameTree);
        logInspect_s_.debug((Object)"No problems occurred,");
    }

    private static void throwIfInvalidImpl(IdentityHashMap<GameTree, Object> identityHashMap, IdentityHashMap<Node, Object> identityHashMap2, GameTree gameTree) {
        if (identityHashMap.containsKey(gameTree)) {
            throw new IllegalArgumentException(gameTree + " show twice");
        }
        identityHashMap.put(gameTree, new Object());
        GameTree gameTree2 = Sgfs.getRoot(gameTree);
        if (gameTree2 instanceof RootGameTree) {
            if (!identityHashMap.containsKey(gameTree2)) {
                throw new IllegalArgumentException("Another RootGameTree is found. It is " + gameTree2);
            }
        } else {
            throw new IllegalArgumentException(gameTree + "'s root is not RootGameTree. It is " + gameTree2);
        }
        for (Node node : gameTree.getSequence()) {
            if (identityHashMap2.containsKey(node)) {
                throw new IllegalArgumentException(node + " show twice");
            }
            identityHashMap2.put(node, new Object());
        }
        for (GameTree gameTree3 : gameTree.getChildren()) {
            if (gameTree3 instanceof RootGameTree) {
                throw new IllegalArgumentException(gameTree3 + " has RootGameTree.");
            }
            if (gameTree3.getParent() != gameTree) {
                throw new IllegalArgumentException(gameTree3 + " doesn't indicate Parent.");
            }
            SgfArgumentChecker.throwIfInvalidImpl(identityHashMap, identityHashMap2, gameTree3);
        }
    }
}

