/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.EnumSelectionListener;
import org.unitarou.swt.ListenerList;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumCombo<E extends Enum<E>>
implements WidgetContainer {
    private static final MessageResource LB_EMPTY = new MessageResource(EnumCombo.class, "lbEmpty");
    private final ListenerList<EnumSelectionListener<E>> list_;
    private final EnumSet<E> items_;
    private Combo combo_;
    private final EnumSet<Style> style_;
    private final List<E> enumList_;

    public EnumCombo(EnumSet<E> enumSet) {
        this(enumSet, EnumSet.of(Style.READ_ONLY, Style.PERMIT_NO_CHOICE));
    }

    public EnumCombo(EnumSet<E> enumSet, EnumSet<Style> enumSet2) {
        ArgumentChecker.throwIfNull(enumSet, enumSet2);
        this.list_ = new ListenerList<EnumSelectionListener>(EnumSelectionListener.class);
        this.items_ = enumSet.clone();
        this.combo_ = null;
        this.style_ = enumSet2;
        this.enumList_ = new ArrayList(enumSet.size() + (enumSet2.contains((Object)Style.PERMIT_NO_CHOICE) ? 1 : 0));
    }

    @Override
    public Control createContents(Composite composite) {
        this.combo_ = new Combo(composite, 4 | (this.style_.contains((Object)Style.READ_ONLY) ? 8 : 0));
        if (this.style_.contains((Object)Style.PERMIT_NO_CHOICE)) {
            this.combo_.add(LB_EMPTY.get());
            this.enumList_.add(null);
        }
        for (Enum enum_ : this.items_) {
            this.combo_.add(enum_.toString());
            this.enumList_.add(enum_);
        }
        if (this.combo_.getItemCount() != 0) {
            this.combo_.select(0);
        }
        this.combo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EnumCombo.this.fireItemSelected();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                EnumCombo.this.fireDefaultSelected();
            }
        });
        return this.combo_;
    }

    private void fireItemSelected() {
        E e = this.getSelected();
        for (EnumSelectionListener<E> enumSelectionListener : this.list_.getListeners()) {
            enumSelectionListener.itemSelected(e);
        }
    }

    private void fireDefaultSelected() {
        String string = this.combo_.getText();
        for (EnumSelectionListener<E> enumSelectionListener : this.list_.getListeners()) {
            enumSelectionListener.defaultSelected(string);
        }
    }

    public Combo getCombo() {
        return this.combo_;
    }

    public void select(E e) {
        if (this.combo_ == null) {
            return;
        }
        int n = 0;
        for (Enum enum_ : this.enumList_) {
            if (enum_ == e) {
                this.combo_.select(n);
                return;
            }
            ++n;
        }
    }

    public E getSelected() {
        int n = this.combo_.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        return (E)((Enum)this.enumList_.get(n));
    }

    public String getText() {
        return this.combo_.getText();
    }

    public void setText(String string) {
        this.combo_.setText(string);
    }

    public boolean isEnabled() {
        return this.combo_.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.combo_.setEnabled(bl);
    }

    @Override
    public void dispose() {
    }

    public void addListener(EnumSelectionListener<E> enumSelectionListener) {
        this.list_.add(enumSelectionListener);
    }

    public void removeListener(EnumSelectionListener<E> enumSelectionListener) {
        this.list_.remove(enumSelectionListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        READ_ONLY,
        PERMIT_NO_CHOICE;

    }
}

