/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.text.StringCharacterIterator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

public class Swts {
    public static void disposeQuietly(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static Point topLeft(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return Geometry.getLocation((Rectangle)rectangle);
    }

    public static Point bottomRight(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static String toWidgetText(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isISOControl(c) || Character.isWhitespace(c)) {
                if (c == '\r') {
                    if (stringCharacterIterator.next() != '\n') {
                        stringCharacterIterator.previous();
                    }
                    stringBuilder.append(Strings.LINE_SEPARATOR);
                } else if (c == '\n') {
                    stringBuilder.append(Strings.LINE_SEPARATOR);
                } else {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static Point add(Point point, Point point2, int n) {
        Point point3 = new Point(0, 0);
        point3.x = (n & 0x100) != 0 ? point.x + point2.x : Math.max(point.x, point2.x);
        point3.y = (n & 0x200) != 0 ? point.y + point2.y : Math.max(point.y, point2.y);
        return point3;
    }

    protected Swts() {
    }
}

