/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.context;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.util.StrategyRegistrar;
import org.unitarou.util.WeakedList;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContext
implements Context {
    private final Object rootScope_ = new Object();
    private final StrategyRegistrar strategyRegistrar_ = new StrategyRegistrar();
    private final WeakHashMap<Object, Object> scopeMap_ = new WeakHashMap();
    private final WeakHashMap<Object, Map<String, Object>> attributeMap_ = new WeakHashMap();
    private final WeakHashMap<Object, CurrentContext> contextMap_;
    private final WeakedList<ContextListener> listeners_;

    public DefaultContext() {
        this.attributeMap_.put(this.rootScope_, new HashMap());
        this.contextMap_ = new WeakHashMap();
        this.listeners_ = new WeakedList();
    }

    public boolean registerInterface(Class clazz) {
        ArgumentChecker.throwIfNull((Object)clazz);
        return this.strategyRegistrar_.registerStrategy(clazz);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.strategyRegistrar_.getStrategies();
    }

    @Override
    public Class<?>[] registerProvider(Class<?> clazz) {
        Class<?>[] classArray;
        ArgumentChecker.throwIfNull(clazz);
        for (Class<?> clazz2 : classArray = this.strategyRegistrar_.registerConcreteStrategy(clazz)) {
            this.getProvider(clazz2, null);
        }
        return classArray;
    }

    @Override
    public void loadContext() {
    }

    @Override
    public void saveContext() {
    }

    @Override
    public void setProvider(Class<?> clazz, Class<?> clazz2, Object object) {
        ArgumentChecker.throwIfNull(clazz, clazz2);
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Interface mismatch: " + clazz + " is no assignable from " + clazz2);
        }
        Class<?>[] classArray = this.strategyRegistrar_.getConcreteStrategies(clazz);
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].equals(clazz2)) continue;
            this.setProviderImpl(clazz, clazz2, object);
            return;
        }
        this.setProviderImpl(clazz, clazz2, object);
    }

    private void setProviderImpl(Class clazz, Class clazz2, Object object) {
        try {
            this.setAttribute(clazz.getName(), clazz2.newInstance(), object);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Instantiation failure:" + clazz2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Constructer access failure:" + clazz2);
        }
    }

    @Override
    public <T extends Provider> T[] getProviders(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        return (Provider[])this.strategyRegistrar_.getConcreteStrategyInstances(clazz);
    }

    @Override
    public <T extends Provider> T getProvider(Class<T> clazz, Object object) {
        ArgumentChecker.throwIfNull(clazz);
        T t = this.getProviderFromAttribute(clazz, object);
        if (t != null) {
            return t;
        }
        return (T)((Provider)this.getProviderByCreateInstance(clazz, object));
    }

    private <T extends Provider> T getProviderFromAttribute(Class<T> clazz, Object object) {
        Object object2 = this.getAttribute(clazz.getName(), object);
        if (object2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(object2.getClass())) {
            throw new IllegalStateException("Bad attribute for " + clazz + ". " + object2 + " is not an instance of " + Provider.class);
        }
        return (T)((Provider)object2);
    }

    private <T> T getProviderByCreateInstance(Class<T> clazz, Object object) {
        Class<T>[] classArray = this.strategyRegistrar_.getConcreteStrategies(clazz);
        if (classArray.length == 0) {
            throw new IllegalStateException("There are any concrete providers for " + clazz);
        }
        try {
            T t = classArray[0].newInstance();
            this.setAttribute(clazz.getName(), t, object);
            return t;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Bad attribute for " + clazz + ". " + classArray[0] + " is not an instance of " + Provider.class);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Provider " + classArray[0] + " has no default constructer.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Default constructer for provider " + classArray[0] + " is not public scope.");
        }
    }

    @Override
    public void setAttribute(String string, Object object, Object object2) {
        HashMap<String, Object> hashMap;
        ArgumentChecker.throwIfNull((Object)string, object);
        object2 = this.toRootScopeIfNull(object2);
        if (object2 instanceof Collection) {
            this.scopeMap_.put(object2, this.rootScope_);
        } else if (object2 instanceof RootGameTree && (hashMap = this.findCollection((RootGameTree)object2)) != null) {
            this.scopeMap_.put(hashMap, object2);
        }
        hashMap = this.attributeMap_.get(object2);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            this.attributeMap_.put(object2, hashMap);
        }
        hashMap.put(string, object);
    }

    @Override
    public void setAttribute(ContextValue contextValue, Object object) {
        ArgumentChecker.throwIfNull((Object)contextValue);
        this.setAttribute(contextValue.id(), contextValue.defaultValue(), object);
    }

    private Object toRootScopeIfNull(Object object) {
        return object == null ? this.rootScope_ : object;
    }

    private Collection findCollection(RootGameTree rootGameTree) {
        for (Object object : this.scopeMap_.keySet()) {
            if (!(object instanceof Collection)) continue;
            Collection collection = (Collection)object;
            for (int i = 0; i < collection.size(); ++i) {
                if (rootGameTree != collection.get(i)) continue;
                return collection;
            }
        }
        return null;
    }

    @Override
    public String[] rootKeys() {
        Map<String, Object> map = this.attributeMap_.get(this.rootScope_);
        return map.keySet().toArray(new String[map.size()]);
    }

    @Override
    public Object getAttribute(String string, Object object) {
        Object v;
        Map map;
        ArgumentChecker.throwIfNull((Object)string);
        object = this.toRootScopeIfNull(object);
        Map<String, Object> map2 = this.attributeMap_.get(this.rootScope_);
        do {
            if ((v = (map = this.findMap(object)).get(string)) != null) {
                return v;
            }
            object = this.scopeMap_.get(object);
            object = this.toRootScopeIfNull(object);
        } while (map != map2);
        return v;
    }

    private Map findMap(Object object) {
        Map<String, Object> map = this.attributeMap_.get(object);
        while (map == null) {
            object = this.scopeMap_.get(object);
            object = this.toRootScopeIfNull(object);
            map = this.attributeMap_.get(object);
        }
        return map;
    }

    @Override
    public CurrentContext getCurrent(Object object) {
        CurrentContext currentContext = this.contextMap_.get(object = this.toRootScopeIfNull(object));
        if (currentContext == null) {
            currentContext = new CurrentContextImpl(object);
            this.contextMap_.put(object, currentContext);
        }
        return currentContext;
    }

    @Override
    public Object[] clearCurrent(Object object) {
        object = this.toRootScopeIfNull(object);
        this.scopeMap_.remove(object);
        Map<String, Object> map = this.attributeMap_.remove(object);
        this.contextMap_.remove(object);
        if (map == null) {
            return new Object[0];
        }
        return map.keySet().toArray();
    }

    @Override
    public void addListener(ContextListener contextListener) {
        if (contextListener == null) {
            return;
        }
        this.listeners_.add(contextListener);
    }

    @Override
    public void removeListener(ContextListener contextListener) {
        this.listeners_.remove(contextListener);
    }

    @Override
    public void fireAttributeChanged(String[] stringArray) {
        ArgumentChecker.throwIfNull((Object)stringArray);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Set<String> set = Collections.unmodifiableSet(hashSet);
        ContextListener[] contextListenerArray = this.listeners_.toArray((ContextListener[])new ContextListener[0]);
        for (int i = 0; i < contextListenerArray.length; ++i) {
            contextListenerArray[i].attributeChanged(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentContextImpl
    implements CurrentContext {
        private final WeakReference<Object> reference_;

        private CurrentContextImpl(Object object) {
            this.reference_ = new WeakReference<Object>(object);
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> clazz) {
            return DefaultContext.this.getProvider(clazz, this.reference_.get());
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> clazz, Provider provider) {
            DefaultContext.this.setAttribute(clazz.getName(), provider, this.reference_.get());
        }

        @Override
        public boolean getBoolean(String string) {
            Object object = DefaultContext.this.getAttribute(string, this.reference_.get());
            if (object == null || !(object instanceof Boolean)) {
                this.throwIllegalStateException(string, object);
            }
            return (Boolean)object;
        }

        @Override
        public boolean getBoolean(BooleanContextValue booleanContextValue) {
            ArgumentChecker.throwIfNull((Object)booleanContextValue);
            Object object = DefaultContext.this.getAttribute(booleanContextValue.id(), this.reference_.get());
            if (object == null || !(object instanceof Boolean)) {
                return booleanContextValue.defaultBoolean();
            }
            return (Boolean)object;
        }

        @Override
        public int getInteger(IntContextValue intContextValue) {
            ArgumentChecker.throwIfNull((Object)intContextValue);
            Object object = DefaultContext.this.getAttribute(intContextValue.id(), this.reference_.get());
            if (object == null || !(object instanceof Integer)) {
                return intContextValue.defaultInt();
            }
            return (Integer)object;
        }

        @Override
        public int getInteger(String string, int n) {
            Object object = DefaultContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return n;
            }
            if (!(object instanceof Integer)) {
                this.throwIllegalStateException(string, object);
            }
            return (Integer)object;
        }

        @Override
        public void setInteger(String string, int n) {
            DefaultContext.this.setAttribute(string, new Integer(n), this.reference_.get());
        }

        @Override
        public int[] getIntArray(String string, int[] nArray) {
            Object object = DefaultContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return nArray;
            }
            if (!(object instanceof int[])) {
                this.throwIllegalStateException(string, object);
            }
            return (int[])object;
        }

        @Override
        public int[] getIntArray(IntArrayContextValue intArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)intArrayContextValue);
            return this.getIntArray(intArrayContextValue.id(), intArrayContextValue.defaultIntArray());
        }

        @Override
        public void setIntArray(String string, int[] nArray) {
            ArgumentChecker.throwIfNull((Object)nArray);
            DefaultContext.this.setAttribute(string, nArray, this.reference_.get());
        }

        @Override
        public File getFile(FileContextValue fileContextValue) {
            ArgumentChecker.throwIfNull((Object)fileContextValue);
            Object object = DefaultContext.this.getAttribute(fileContextValue.id(), this.reference_.get());
            if (object == null) {
                return fileContextValue.defaultFile();
            }
            if (!(object instanceof File)) {
                this.throwIllegalStateException(fileContextValue.id(), fileContextValue);
            }
            return (File)object;
        }

        @Override
        public void setFile(String string, File file) {
            ArgumentChecker.throwIfNull((Object)file);
            DefaultContext.this.setAttribute(string, file, this.reference_.get());
        }

        private void throwIllegalStateException(String string, Object object) {
            throw new IllegalStateException("Bad value. key='" + string + "', value='" + object + "'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullCurrentContext
    implements CurrentContext {
        NullCurrentContext() {
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> clazz) {
            return null;
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> clazz, Provider provider) {
        }

        @Override
        public boolean getBoolean(String string) {
            return false;
        }

        @Override
        public boolean getBoolean(BooleanContextValue booleanContextValue) {
            return false;
        }

        @Override
        public int getInteger(IntContextValue intContextValue) {
            return 0;
        }

        @Override
        public int getInteger(String string, int n) {
            return 0;
        }

        @Override
        public void setInteger(String string, int n) {
        }

        @Override
        public int[] getIntArray(String string, int[] nArray) {
            return nArray;
        }

        @Override
        public void setIntArray(String string, int[] nArray) {
        }

        @Override
        public int[] getIntArray(IntArrayContextValue intArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)intArrayContextValue);
            return intArrayContextValue.defaultIntArray();
        }

        @Override
        public File getFile(FileContextValue fileContextValue) {
            ArgumentChecker.throwIfNull((Object)fileContextValue);
            return fileContextValue.defaultFile();
        }

        @Override
        public void setFile(String string, File file) {
        }
    }
}

