/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.cmd.CommandDriverListener;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.crdlp.NoCoordinatesProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.StartSolvingProblem;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMediator {
    private final RootGameTree root_;
    private final EditableNodeList nodeList_;
    private final CommandDriver commandDriver_;
    private int changedCounter_;
    private boolean isSolvingProblem_;
    private final Map<String, Object> sidetrackContextMap_;

    public GameMediator(RootGameTree rootGameTree) {
        this(rootGameTree, false);
    }

    public GameMediator(RootGameTree rootGameTree, boolean bl) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.root_ = rootGameTree;
        this.nodeList_ = new EditableNodeList(this.root_);
        this.commandDriver_ = new CommandDriver();
        this.commandDriver_.addListener(new ChangeListener());
        this.sidetrackContextMap_ = new HashMap<String, Object>();
        this.initializeByGameType();
        this.changedCounter_ = bl ? 1 : 0;
    }

    private void initializeByGameType() {
        this.isSolvingProblem_ = false;
        this.nodeList_.setPositionIndex(this.nodeList_.size() - 1);
        String string = BasicFinder.findDatum(this.root_.getSequence(), SgfId.GAME_TYPE);
        if (string.equals(GameType.PROBLEM.getString())) {
            this.startSolvingProblem();
        }
    }

    public RootGameTree getRootGameTree() {
        return this.root_;
    }

    public CommandDriver.Status executeCommand(Command4NodeList command4NodeList) {
        ArgumentChecker.throwIfNull((Object)command4NodeList);
        EditableNodeList editableNodeList = command4NodeList.getEditableNodeList();
        if (editableNodeList != null && this.nodeList_ != editableNodeList) {
            throw new IllegalArgumentException("Bad match of EditableNodeList");
        }
        command4NodeList.setEditableNodeList(this.nodeList_);
        return this.commandDriver_.execute(command4NodeList);
    }

    public CommandDriver.Status undo() {
        return this.commandDriver_.undo();
    }

    public CommandDriver.Status redo() {
        return this.commandDriver_.redo();
    }

    public CommandDriver.Status getCommandDriverStatus() {
        return this.commandDriver_.getStatus();
    }

    public NodeList getNodeList() {
        return this.nodeList_;
    }

    public NodeView getCurrentNodeView() {
        return this.nodeList_.getNodeView(this.nodeList_.getPositionIndex());
    }

    public int getCurrentNodeIndex() {
        return this.nodeList_.getPositionIndex();
    }

    public int findNodeView(PropertyType propertyType) {
        int n;
        NodeView nodeView = this.nodeList_.getNodeView(0);
        for (n = this.getCurrentNodeIndex(); 0 <= n && !(nodeView = this.nodeList_.getNodeView(n)).containsPropertyType(propertyType); --n) {
        }
        return n;
    }

    public void setNodeIndex(int n) {
        this.nodeList_.setPositionIndex(n);
    }

    public NodeView setNodeIndexDelta(int n) {
        int n2 = this.nodeList_.getPositionIndex();
        if ((n2 += n) < 0) {
            n2 = 0;
        } else if (this.nodeList_.size() <= n2) {
            n2 = this.nodeList_.size() - 1;
        }
        this.nodeList_.setPositionIndex(n2);
        return this.getCurrentNodeView();
    }

    public GameType getGameType() {
        return this.root_.getGameType();
    }

    public boolean isChanged() {
        return this.changedCounter_ != 0;
    }

    public void clearChanged() {
        this.changedCounter_ = 0;
    }

    public void startSolvingProblem() {
        if (this.isSolvingProblem_) {
            this.finishSolvingProblem();
        }
        this.storeContextForSolvingProblem();
        this.isSolvingProblem_ = true;
        StartSolvingProblem startSolvingProblem = new StartSolvingProblem(this);
        this.commandDriver_.execute(startSolvingProblem);
    }

    private void storeContextForSolvingProblem() {
        Context context = Yukinoshita.context();
        this.sidetrackContextMap_.clear();
        this.sidetrackContextMap_.put(Context.SHOW_LAST_MOVE_MARK.id(), context.getAttribute(Context.SHOW_LAST_MOVE_MARK.id(), this.root_));
        this.sidetrackContextMap_.put(VariationLabelProvider.class.getName(), context.getProvider(VariationLabelProvider.class, this.root_));
        this.sidetrackContextMap_.put(CoordinatesLabelProvider.class.getName(), context.getProvider(CoordinatesLabelProvider.class, this.root_));
        context.setAttribute(Context.SHOW_LAST_MOVE_MARK.id(), Boolean.FALSE, this.root_);
        context.setProvider(VariationLabelProvider.class, NoVariationProvider.class, this.root_);
        context.setProvider(CoordinatesLabelProvider.class, NoCoordinatesProvider.class, this.root_);
        Set<String> set = this.sidetrackContextMap_.keySet();
        context.fireAttributeChanged(set.toArray(new String[set.size()]));
    }

    public void finishSolvingProblem() {
        if (!this.isSolvingProblem_) {
            return;
        }
        Command command = null;
        while (this.commandDriver_.getStatus().isUndoable()) {
            CommandDriver.Status status = this.commandDriver_.undo();
            Command command2 = status.getExecutedCommand();
            if (command == null) {
                command = command2;
            }
            if (!(command2 instanceof StartSolvingProblem)) continue;
            this.isSolvingProblem_ = false;
            this.commandDriver_.clearRedo();
            this.restoreContextBySolvingProblem();
            return;
        }
        if (command != null) {
            while (command != this.commandDriver_.redo()) {
            }
        }
        this.isSolvingProblem_ = false;
        this.restoreContextBySolvingProblem();
        throw new IllegalStateException("Can't find StartSolvingProblem command.");
    }

    private void restoreContextBySolvingProblem() {
        Context context = Yukinoshita.context();
        for (Map.Entry<String, Object> entry : this.sidetrackContextMap_.entrySet()) {
            context.setAttribute(entry.getKey(), entry.getValue(), this.root_);
        }
        Set<String> set = this.sidetrackContextMap_.keySet();
        context.fireAttributeChanged(set.toArray(new String[set.size()]));
    }

    public SgfPoint[] findInvalidPoints() {
        CommandDriver commandDriver = new CommandDriver();
        Set<SgfPoint> set = this.validatePoint(this.nodeList_, this.nodeList_.getPositionIndex(), commandDriver);
        while (commandDriver.getStatus().isUndoable()) {
            commandDriver.undo();
        }
        return set.toArray(new SgfPoint[set.size()]);
    }

    private Set<SgfPoint> validatePoint(EditableNodeList editableNodeList, int n, CommandDriver commandDriver) {
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        while (n < editableNodeList.size()) {
            editableNodeList.setPositionIndex(n);
            NodeEntity nodeEntity = editableNodeList.getPosition();
            hashSet.addAll(nodeEntity.getIgoBoard().validate());
            if (nodeEntity.getNodeTree().getVariationSize() == 0) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            hashSet.addAll(this.validatePoint(editableNodeList, n2, commandDriver));
            for (int i = 1; i < nodeEntity.getNodeTree().getVariationSize(); ++i) {
                editableNodeList.setPositionIndex(n);
                SelectVariation selectVariation = new SelectVariation(i);
                selectVariation.setEditableNodeList(editableNodeList);
                commandDriver.execute(selectVariation);
                hashSet.addAll(this.validatePoint(editableNodeList, n2, commandDriver));
            }
        }
        return hashSet;
    }

    public CurrentContext getContext() {
        return Yukinoshita.context().getCurrent(this.root_);
    }

    private class ChangeListener
    implements CommandDriverListener {
        private final Set<Class<? extends Command4NodeList>> ignoreCommandSet_ = new HashSet<Class<? extends Command4NodeList>>();

        public ChangeListener() {
            this.ignoreCommandSet_.add(SelectVariation.class);
            this.ignoreCommandSet_.add(StartSolvingProblem.class);
        }

        private boolean isChangedCommand(Command command) {
            return !GameMediator.this.isSolvingProblem_ && !this.ignoreCommandSet_.contains(command.getClass());
        }

        public void undoExecuted(Command command) {
            if (this.isChangedCommand(command)) {
                --GameMediator.this.changedCounter_;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getUndoneNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }

        public void executed(Command command) {
            if (this.isChangedCommand(command)) {
                ++GameMediator.this.changedCounter_;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getExecutedNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }

        public void redoExecuted(Command command) {
            if (this.isChangedCommand(command)) {
                ++GameMediator.this.changedCounter_;
            }
            if (command instanceof Command4NodeList) {
                GameMediator.this.nodeList_.setPositionIndex(((Command4NodeList)command).getExecutedNodeIndex());
            } else {
                GameMediator.this.nodeList_.setPositionIndex(0);
            }
        }
    }
}

