/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.cmd.RemoveNode;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCurrentNode
extends Command4NodeList {
    private static final MessageResource LB_NAME = new MessageResource(RemoveCurrentNode.class, "lbName");
    private boolean isSetuped_ = false;
    private Command sgfCommand_ = null;

    @Override
    protected boolean setup() {
        if (this.isSetuped_) {
            return true;
        }
        EditableNodeList editableNodeList = this.getEditableNodeList();
        if (editableNodeList == null) {
            return false;
        }
        this.setDisplayName(LB_NAME.get());
        NodeEntity nodeEntity = editableNodeList.getPosition();
        this.sgfCommand_ = new RemoveNode(nodeEntity.getNodeTree().getGameTree(), nodeEntity.getNode());
        int n = editableNodeList.getPositionIndex();
        this.setExecutedNodeIndex(n - 1);
        this.setUndoneNodeIndex(n);
        this.isSetuped_ = true;
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        EditableNodeList editableNodeList = this.getEditableNodeList();
        editableNodeList.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity nodeEntity = editableNodeList.getPosition();
        while (!nodeEntity.equals(editableNodeList.removeLast())) {
        }
        editableNodeList.addLast(nodeEntity);
        GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
        boolean bl = false;
        for (Node node : gameTree.getSequence()) {
            if (node == nodeEntity.getNode()) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        EditableNodeList editableNodeList = this.getEditableNodeList();
        editableNodeList.setPositionIndex(this.getExecutedNodeIndex());
        NodeEntity nodeEntity = editableNodeList.getPosition();
        while (!nodeEntity.equals(editableNodeList.removeLast())) {
        }
        GameTree gameTree = nodeEntity.getNodeTree().getGameTree();
        boolean bl = false;
        for (Node node : gameTree.getSequence()) {
            if (node == nodeEntity.getNode()) {
                bl = true;
            }
            if (!bl) continue;
            this.getEditableNodeList().addLast(node, gameTree);
        }
        if (gameTree.getChildrenSize() != 0) {
            this.getEditableNodeList().addLast(gameTree.getChild(0));
        }
        editableNodeList.setPositionIndex(this.getUndoneNodeIndex());
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_DOWNWARD, ModelInfluence.NODE_CURRENT);
    }
}

