/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.Command4View;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

public abstract class AbstractCommand4View
implements Command4View {
    private static final Log log_s_ = LogFactory.getLog(AbstractCommand4View.class);
    private final ParameterImpl parameter_ = new ParameterImpl();

    public final Command4View.Parameter getParameter() {
        return this.parameter_;
    }

    protected final CollectionEditor getCollectionEditor() {
        return this.parameter_.collectionEditor_;
    }

    protected final EventBroker getEventBroker() {
        return this.parameter_.eventBroker_;
    }

    protected final Boolean isEditMode() {
        return this.parameter_.isEditMode_;
    }

    protected final void fireCollectionViewerUpdate() {
        this.throwIfNotSetup();
        GameType gameType = this.parameter_.collectionEditor_.getActiveGame().getGameType();
        this.parameter_.eventBroker_.connect(gameType, this.parameter_.isEditMode_);
        for (CollectionMonitor collectionMonitor : this.parameter_.eventBroker_.getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(this.parameter_.collectionEditor_);
        }
    }

    protected final void fireGameViewerUpdate() {
        this.throwIfNotSetup();
        ViewerUtils.setupDriiRootDirectory(this.parameter_.collectionEditor_.getCollection());
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        for (GameMonitor gameMonitor : this.parameter_.eventBroker_.getListeners(GameMonitor.class)) {
            gameMonitor.update(gameMediator);
        }
    }

    protected final void fireGameInfoNodeUpdate() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        int n = gameMediator.findNodeView(PropertyType.GAME_INFO);
        if (n < 0) {
            n = 0;
        }
        NodeView nodeView = gameMediator.getNodeList().getNodeView(n);
        this.fireGameInfoNodeUpdate(nodeView);
    }

    protected final void fireGameInfoNodeUpdate(NodeView nodeView) {
        this.throwIfNotSetup();
        for (GameInfoNodeMonitor gameInfoNodeMonitor : this.parameter_.eventBroker_.getListeners(GameInfoNodeMonitor.class)) {
            gameInfoNodeMonitor.gameInfoChanged(nodeView);
        }
    }

    protected final void fireNodeListUpdate() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        NodeList nodeList = gameMediator.getNodeList();
        int n = gameMediator.getCurrentNodeIndex();
        int n2 = nodeList.size();
        int n3 = 0;
        NodeView[] nodeViewArray = new NodeView[n2 - n];
        for (int i = n; i < n2; ++i) {
            nodeViewArray[n3] = nodeList.getNodeView(i);
            ++n3;
        }
        for (NodeListMonitor nodeListMonitor : this.parameter_.eventBroker_.getListeners(NodeListMonitor.class)) {
            nodeListMonitor.update(nodeViewArray);
        }
    }

    protected final void fireNodeViewerUpdate() {
        this.fireNodeViewerUpdate(0);
    }

    protected final void fireNodeViewerUpdate(int n) {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        GameMediator gameMediator = this.parameter_.collectionEditor_.getActiveGame();
        int n2 = gameMediator.getCurrentNodeIndex() + n;
        if (n2 < 0 || gameMediator.getNodeList().size() <= n2) {
            n2 = gameMediator.getCurrentNodeIndex();
            log_s_.warn((Object)("Bad index, index=" + n2 + ", delta=" + n));
        }
        NodeView nodeView = gameMediator.getNodeList().getNodeView(n2);
        for (NodeMonitor nodeMonitor : this.parameter_.eventBroker_.getListeners(NodeMonitor.class)) {
            nodeMonitor.currentChanged(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace((Object)(stopWatch.lapSecond() + " secs for " + nodeMonitor));
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace((Object)(stopWatch.stopSecond() + " secs for fireNodeViewerUpdate"));
        }
    }

    protected final void fireHandlerPhaseChange(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        if (handlerPhase.equals(HandlerPhase.SOLVE)) {
            this.parameter_.collectionEditor_.getActiveGame().startSolvingProblem();
            this.fireNodeViewerUpdate();
        }
        for (ControllerStatusMonitor controllerStatusMonitor : this.parameter_.eventBroker_.getListeners(ControllerStatusMonitor.class)) {
            controllerStatusMonitor.changeHandlerPhase(handlerPhase);
        }
    }

    protected final void fireProblemStatusUpdate(ProblemStatus problemStatus) {
        ArgumentChecker.throwIfNull((Object)problemStatus);
        for (ProblemStatusMonitor problemStatusMonitor : this.parameter_.eventBroker_.getListeners(ProblemStatusMonitor.class)) {
            problemStatusMonitor.update(problemStatus);
        }
    }

    protected void fireCommandDriverExecuted(CommandDriver.Status status) {
        ArgumentChecker.throwIfNull((Object)status);
        for (CommandDriverMonitor commandDriverMonitor : this.parameter_.eventBroker_.getListeners(CommandDriverMonitor.class)) {
            commandDriverMonitor.commandExecuted(status);
        }
    }

    protected final void throwIfNotSetup() {
        if (this.parameter_.collectionEditor_ == null || this.parameter_.eventBroker_ == null || this.parameter_.isEditMode_ == null) {
            throw new IllegalStateException("Bad state, CollectionEditor and EventBroker must be set before method invocationcollectionEditor_=" + this.parameter_.collectionEditor_ + ", eventBroker_=" + this.parameter_.eventBroker_ + ", isEditMode_=" + this.parameter_.isEditMode_);
        }
    }

    private class ParameterImpl
    implements Command4View.Parameter {
        private CollectionEditor collectionEditor_;
        private EventBroker eventBroker_;
        private Boolean isEditMode_;
        private HandlerPhase currentStatus_;

        private ParameterImpl() {
        }

        public CollectionEditor getCollectionEditor() {
            return this.collectionEditor_;
        }

        public EventBroker getEventBroker() {
            return this.eventBroker_;
        }

        public Boolean isEditMode() {
            return this.isEditMode_;
        }

        public HandlerPhase getCurrentStatus() {
            return this.currentStatus_;
        }

        public void set(CollectionEditor collectionEditor, EventBroker eventBroker, boolean bl) {
            ArgumentChecker.throwIfNull((Object)collectionEditor, (Object)eventBroker);
            this.collectionEditor_ = collectionEditor;
            this.eventBroker_ = eventBroker;
            this.isEditMode_ = new Boolean(bl);
        }

        public void setCollectionEditor(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            this.collectionEditor_ = collectionEditor;
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_ = eventBroker;
        }

        public void setEditMode(boolean bl) {
            this.isEditMode_ = new Boolean(bl);
        }

        public void setCurrentStatus(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            this.currentStatus_ = handlerPhase;
        }
    }
}

