/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.AbstractCommand4View;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

public class ChangeEditModeCommand
extends AbstractCommand4View {
    private static Log log_s_ = LogFactory.getLog(ChangeEditModeCommand.class);

    public ChangeEditModeCommand(boolean bl) {
        this.getParameter().setEditMode(bl);
    }

    public void execute() {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        CollectionEditor collectionEditor = this.getCollectionEditor();
        EventBroker eventBroker = this.getEventBroker();
        boolean bl = this.isEditMode();
        if (GameType.DRILL.equals(collectionEditor.getCollection().get(0).getGameType())) {
            this.editModeChangedInDrill();
        } else {
            GameMediator gameMediator = collectionEditor.getActiveGame();
            eventBroker.connect(gameMediator.getGameType(), bl);
            if (gameMediator.getGameType().equals(GameType.PROBLEM)) {
                if (bl) {
                    gameMediator.finishSolvingProblem();
                    this.fireNodeViewerUpdate();
                } else {
                    gameMediator.startSolvingProblem();
                    this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
                }
            }
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace((Object)(stopWatch.stopSecond() + " secs for update"));
        }
        for (ControllerStatusMonitor controllerStatusMonitor : eventBroker.getListeners(ControllerStatusMonitor.class)) {
            controllerStatusMonitor.setEditMode(bl);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace((Object)(stopWatch.stopSecond() + " secs for ControllerStatusMonitor.setEditMode"));
        }
    }

    private void editModeChangedInDrill() {
        CollectionEditor collectionEditor = this.getCollectionEditor();
        EventBroker eventBroker = this.getEventBroker();
        boolean bl = this.isEditMode();
        if (bl) {
            collectionEditor.getActiveGame().finishSolvingProblem();
            collectionEditor.setActiveGame(0);
            while (1 < collectionEditor.size()) {
                collectionEditor.remove(1);
            }
            eventBroker.connect(collectionEditor.getActiveGame().getGameType(), bl);
            this.fireGameViewerUpdate();
            this.fireNodeViewerUpdate();
        } else {
            Collection collection = collectionEditor.getCollection();
            ViewerUtils.setupDriiRootDirectory(collection);
            CollectionRepository.instance().loadProblem(collection);
            collectionEditor.setActiveGame(1);
            eventBroker.connect(collectionEditor.getActiveGame().getGameType(), bl);
            this.fireGameViewerUpdate();
            collectionEditor.getActiveGame().startSolvingProblem();
            this.fireHandlerPhaseChange(HandlerPhase.SOLVE);
        }
    }
}

