/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.ArrayList;
import java.util.Random;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.cmd.AbstractCommand4View;

public class MoveInProblemCommand
extends AbstractCommand4View {
    private final SgfPoint point_;

    public MoveInProblemCommand(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        this.point_ = sgfPoint;
    }

    public void execute() {
        this.throwIfNotSetup();
        GameMediator gameMediator = this.getCollectionEditor().getActiveGame();
        if (this.selectPlayerMove(gameMediator, this.point_)) {
            this.fireNodeViewerUpdate();
            this.fireProblemStatusUpdate(ProblemStatus.WRONG);
            return;
        }
        SgfColor sgfColor = gameMediator.getCurrentNodeView().getMove().getColor();
        try {
            this.fireNodeViewerUpdate();
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.selectOppositeMove(gameMediator)) {
            this.fireNodeViewerUpdate();
        }
        if (!gameMediator.getCurrentNodeView().isLast()) {
            return;
        }
        if (this.isInMainPath(gameMediator)) {
            this.fireProblemStatusUpdate(ProblemStatus.CORRECT);
            return;
        }
        NodeView nodeView = gameMediator.getCurrentNodeView();
        this.fireProblemStatusUpdate(this.judge(nodeView, sgfColor));
    }

    private boolean selectPlayerMove(GameMediator gameMediator, SgfPoint sgfPoint) {
        NodeView nodeView = gameMediator.getCurrentNodeView();
        if (nodeView.isChildrenStyle()) {
            boolean bl = this.selectPlayerMoveByVariation(gameMediator, sgfPoint);
            NodeView nodeView2 = gameMediator.setNodeIndexDelta(1);
            if (bl) {
                return false;
            }
            if (sgfPoint.equals(nodeView2.getMove().getPoint())) {
                return false;
            }
            gameMediator.setNodeIndexDelta(-1);
            gameMediator.executeCommand(new AddVariation(nodeView2.getMove().getColor(), sgfPoint));
            gameMediator.setNodeIndexDelta(1);
            return true;
        }
        NodeView nodeView3 = gameMediator.setNodeIndexDelta(1);
        if (this.selectPlayerMoveByVariation(gameMediator, sgfPoint)) {
            return false;
        }
        if (sgfPoint.equals(nodeView3.getMove().getPoint())) {
            return false;
        }
        gameMediator.setNodeIndexDelta(-1);
        gameMediator.executeCommand(new AddVariation(nodeView3.getMove().getColor(), sgfPoint));
        return false;
    }

    private boolean selectPlayerMoveByVariation(GameMediator gameMediator, SgfPoint sgfPoint) {
        NodeView nodeView = gameMediator.getCurrentNodeView();
        NodeView[] nodeViewArray = nodeView.getVariations();
        if (nodeViewArray.length == 0) {
            return false;
        }
        int n = -1;
        Stone stone = null;
        for (int i = 0; i < nodeViewArray.length; ++i) {
            stone = nodeViewArray[i].getMove();
            SgfPoint sgfPoint2 = stone.getPoint();
            if (n == -1 && sgfPoint2 != null && sgfPoint2.condition().equals((Object)SgfPointType.PASS)) {
                n = i;
                continue;
            }
            if (!sgfPoint.equals(sgfPoint2)) continue;
            gameMediator.executeCommand(new SelectVariation(i));
            return true;
        }
        if (n != -1) {
            gameMediator.executeCommand(new SelectVariation(n));
            SgfId sgfId = stone.getColor().moveType();
            gameMediator.executeCommand(new UpdateProperty(new Property[0], new Property(sgfId, sgfPoint.getString()), null));
            return true;
        }
        return false;
    }

    private boolean selectOppositeMove(GameMediator gameMediator) {
        int n;
        NodeView nodeView = gameMediator.getCurrentNodeView();
        if (nodeView.isLast()) {
            return false;
        }
        if (nodeView.isChildrenStyle()) {
            int n2;
            NodeView[] nodeViewArray = nodeView.getVariations();
            if (nodeViewArray.length != 0 && 0 < (n2 = this.getOppositeVariationIndex(nodeViewArray))) {
                gameMediator.executeCommand(new SelectVariation(n2));
            }
            gameMediator.setNodeIndexDelta(1);
            return true;
        }
        gameMediator.setNodeIndexDelta(1);
        NodeView[] nodeViewArray = gameMediator.getCurrentNodeView().getVariations();
        if (nodeViewArray.length != 0 && 0 < (n = this.getOppositeVariationIndex(nodeViewArray))) {
            gameMediator.executeCommand(new SelectVariation(n));
        }
        return true;
    }

    private int getOppositeVariationIndex(NodeView[] nodeViewArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nodeViewArray.length);
        for (int i = 0; i < nodeViewArray.length; ++i) {
            Property property = nodeViewArray[i].getProperty(SgfId.BAD_MOVE);
            if (property != null) continue;
            arrayList.add(new Integer(i));
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        Random random = new Random();
        return (Integer)arrayList.get(random.nextInt(arrayList.size()));
    }

    private boolean isInMainPath(GameMediator gameMediator) {
        for (int i = gameMediator.getCurrentNodeIndex(); 0 <= i; --i) {
            NodeView nodeView = gameMediator.getNodeList().getNodeView(i);
            if (0 >= nodeView.getSelectedVariationIndex()) continue;
            return false;
        }
        return true;
    }

    private ProblemStatus judge(NodeView nodeView, SgfColor sgfColor) {
        Property property = null;
        if (SgfColor.BLACK.equals(sgfColor)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_BLACK);
        } else if (SgfColor.WHITE.equals(sgfColor)) {
            property = nodeView.getProperty(SgfId.GOOD_FOR_WHITE);
        }
        if (property != null) {
            SgfDouble sgfDouble = SgfDouble.parseQuietly(property.getString());
            if (SgfDouble.EMPHASIZED.equals(sgfDouble)) {
                return ProblemStatus.CORRECT;
            }
            if (SgfDouble.NORMAL.equals(sgfDouble)) {
                return ProblemStatus.QUASI_CORRECT;
            }
        }
        return ProblemStatus.WRONG;
    }
}

