/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.window.WindowManager;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;

public class JFaceApplication
implements Application {
    private static final Log log_s_ = LogFactory.getLog(JFaceApplication.class);
    private final WindowManager windowManager_;
    private final JFaceContext context_;
    private final Display display_ = new Display();
    private final Shell shell_;
    private static final MessageResource MSG_INNER_ERROR = new MessageResource(JFaceApplication.class, "msgInnerError");
    private static final MessageResource MSG_FATAL_INNER_ERROR = new MessageResource(JFaceApplication.class, "msgFatalInnerError");

    public JFaceApplication() {
        this.windowManager_ = new WindowManager();
        this.context_ = new JFaceContext();
        this.context_.registerInterface(StonePainter.class);
        Window.setExceptionHandler((Window.IExceptionHandler)new ExceptionHandler());
        this.shell_ = new Shell(this.display_);
    }

    public void dispose() {
        this.display_.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(File[] fileArray) {
        this.context_.registerProvider(StonePainter.CONTEXT.defaultProvider().getClass());
        try {
            this.createWindow();
            JFaceWindow jFaceWindow = (JFaceWindow)this.windowManager_.getWindows()[0];
            for (File file : fileArray) {
                Collection collection = FileManager.instance().open(file);
                if (collection == null) continue;
                jFaceWindow.register(collection, "", false);
            }
            while (!this.shell_.isDisposed()) {
                if (!this.display_.readAndDispatch()) {
                    this.display_.sleep();
                }
                if (this.windowManager_.getWindowCount() != 0) continue;
                this.shell_.dispose();
            }
            this.context_.saveContext();
        }
        catch (Throwable throwable) {
            log_s_.error((Object)"Fatal internal error occurred.", throwable);
            MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), BasicMessages.NT_ERROR.get(), null, MSG_FATAL_INNER_ERROR.get(), 1, new String[]{BasicMessages.CLB_CLOSE.get()}, 0);
            messageDialog.open();
            this.windowManager_.close();
        }
        finally {
            Display.getCurrent().dispose();
        }
    }

    public void createWindow() {
        JFaceWindow jFaceWindow = new JFaceWindow(null);
        this.windowManager_.add((Window)jFaceWindow);
        jFaceWindow.setBlockOnOpen(false);
        jFaceWindow.open();
    }

    public void closeAllWindows() {
        this.windowManager_.close();
    }

    public Context getContext() {
        return this.context_;
    }

    public void openMessageDialog(Application.MessageLevel messageLevel, String string, String string2) {
        ArgumentChecker.throwIfNull((Object)messageLevel, (Object)string, (Object)string2);
        Display display = Display.getCurrent();
        Shell shell = display != null ? display.getActiveShell() : new Shell();
        switch (messageLevel) {
            case ERROR: {
                MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                break;
            }
            case WARNING: {
                MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                break;
            }
            case INFORMATION: {
                MessageDialog.openInformation((Shell)shell, (String)string, (String)string2);
                break;
            }
            default: {
                assert (false) : "Unknown type:" + (Object)((Object)messageLevel);
                break;
            }
        }
    }

    public File openDirectoryDialog(String string, String string2, File file) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2, (Object)file);
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        directoryDialog.setText(string);
        directoryDialog.setMessage(string2);
        String string3 = file.isDirectory() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
        directoryDialog.setFilterPath(string3);
        string3 = directoryDialog.open();
        return string3 == null ? null : new File(string3);
    }

    public WindowController[] getAllController() {
        Window[] windowArray = this.windowManager_.getWindows();
        ArrayList<WindowController> arrayList = new ArrayList<WindowController>(windowArray.length - 1);
        for (Window window : windowArray) {
            if (!(window instanceof WindowController)) continue;
            arrayList.add((WindowController)window);
        }
        return arrayList.toArray(new WindowController[arrayList.size()]);
    }

    private class ExceptionHandler
    implements Window.IExceptionHandler {
        private ExceptionHandler() {
        }

        public void handleException(Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            log_s_.error((Object)"SWT internal error occurred.", throwable);
            MessageDialog messageDialog = new MessageDialog(Display.getCurrent().getActiveShell(), BasicMessages.NT_ERROR.get(), null, MSG_INNER_ERROR.get(), 1, new String[]{BasicMessages.CLB_CLOSE.get()}, 0);
            messageDialog.open();
        }
    }
}

