/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.DefaultContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceContext
extends PreferenceStore
implements Context {
    private static String DELIMITER_ARRAY = ",";
    private static final Log log_s_ = LogFactory.getLog(JFaceContext.class);
    private static final MessageResource MSG_IO_ERROR_IN_RESTORE = new MessageResource(JFaceContext.class, "msgIoErrorInRestore");
    private static final MessageResource MSG_IO_ERROR_IN_SAVE = new MessageResource(JFaceContext.class, "msgIoErrorInSave");
    private final DefaultContext defaultContext_;
    private final WeakHashMap<Object, CurrentContext> contextMap_;
    private File file_;

    public JFaceContext() {
        this.setFilename(Yukinoshita.USER_NAME + ".preference");
        this.defaultContext_ = new DefaultContext();
        this.contextMap_ = new WeakHashMap();
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JFaceContext.this.propertyChangeImpl(propertyChangeEvent.getProperty(), propertyChangeEvent.getNewValue());
            }
        });
    }

    private void propertyChangeImpl(String string, Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.getAttribute(string, null);
        Object object3 = null;
        if (object2 == null || object2.getClass().isAssignableFrom(object.getClass())) {
            object3 = object;
        } else if (object2 instanceof Integer) {
            object3 = new Integer(object.toString());
        } else if (object2 instanceof int[]) {
            object3 = this.parseIntArray(object);
        } else if (object2 instanceof Boolean) {
            object3 = new Boolean(object.toString());
        } else if (object2 instanceof Enum) {
            for (Object obj : object2.getClass().getEnumConstants()) {
                if (!((Enum)obj).name().equals(object.toString())) continue;
                object3 = obj;
            }
        } else if (object2 instanceof Provider) {
            try {
                object3 = Class.forName(object.toString()).newInstance();
            }
            catch (Exception exception) {
                log_s_.warn((Object)(exception.getMessage() + " Bad class name: " + object));
            }
        } else if (object2 instanceof File) {
            object3 = new File(object2.toString());
        } else {
            log_s_.warn((Object)this.composeWarnMsgUnknownTypeValue(string, object2));
        }
        if (object3 == null) {
            return;
        }
        this.defaultContext_.setAttribute(string, object3, null);
        this.defaultContext_.fireAttributeChanged(new String[]{string});
        if (log_s_.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Property changed. ");
            stringBuilder.append(string).append("=").append(object);
            log_s_.debug((Object)stringBuilder.toString());
        }
    }

    private int[] parseIntArray(Object object) {
        Object object2;
        if (object instanceof int[]) {
            int[] nArray = new int[((int[])object).length];
            System.arraycopy(object, 0, nArray, 0, nArray.length);
            return nArray;
        }
        if (!(object instanceof String)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, DELIMITER_ARRAY);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object2 = stringTokenizer.nextToken();
                Integer n = Integer.decode(((String)object2).trim());
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                log_s_.warn((Object)"Bad value.", (Throwable)numberFormatException);
                return null;
            }
        }
        object2 = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = (Integer)arrayList.get(i);
        }
        return object2;
    }

    private String formatIntArray(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(n).append(DELIMITER_ARRAY);
        }
        stringBuilder.delete(stringBuilder.length() - DELIMITER_ARRAY.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    private String composeWarnMsgUnknownTypeValue(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown value type, ignore this attribute: (");
        stringBuilder.append(string).append("=").append(object);
        stringBuilder.append(") class=").append(object.getClass());
        return stringBuilder.toString();
    }

    private String composeMsgMismatchValueType(String string, Object object, Class clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad value type, use default value. key='").append(string);
        stringBuilder.append("', value='").append(object);
        stringBuilder.append("', class=" + clazz);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadContext() {
        this.file_ = new File(Yukinoshita.USER_NAME + ".preference").getAbsoluteFile();
        FileInputStream fileInputStream = null;
        try {
            FileUtils.touch((File)this.file_);
            fileInputStream = new FileInputStream(this.file_);
            this.load(fileInputStream);
            for (String string : this.preferenceNames()) {
                this.propertyChangeImpl(string, this.getString(string));
            }
        }
        catch (IOException iOException) {
            try {
                log_s_.warn((Object)(iOException.getMessage() + " File: " + this.file_.toString()));
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_INPUT.get(), MSG_IO_ERROR_IN_RESTORE.get((Object)iOException.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        this.setFilename(this.file_.getAbsolutePath());
    }

    @Override
    public void saveContext() {
        try {
            super.save();
        }
        catch (IOException iOException) {
            log_s_.warn((Object)("Cant save context. Reason: " + iOException.getMessage()));
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_OUTPUT.get(), MSG_IO_ERROR_IN_SAVE.get((Object)iOException.getMessage()));
        }
    }

    @Override
    public void addListener(ContextListener contextListener) {
        this.defaultContext_.addListener(contextListener);
    }

    @Override
    public Object[] clearCurrent(Object object) {
        this.contextMap_.remove(object);
        return this.defaultContext_.clearCurrent(object);
    }

    @Override
    public void fireAttributeChanged(String[] stringArray) {
        this.defaultContext_.fireAttributeChanged(stringArray);
    }

    @Override
    public Object getAttribute(String string, Object object) {
        return this.defaultContext_.getAttribute(string, object);
    }

    @Override
    public CurrentContext getCurrent(Object object) {
        CurrentContext currentContext = this.contextMap_.get(object);
        if (currentContext == null) {
            currentContext = new CurrentContextImpl(object);
            this.contextMap_.put(object, currentContext);
        }
        return currentContext;
    }

    @Override
    public <T extends Provider> T getProvider(Class<T> clazz, Object object) {
        return this.defaultContext_.getProvider(clazz, object);
    }

    @Override
    public <T extends Provider> T[] getProviders(Class<T> clazz) {
        return this.defaultContext_.getProviders(clazz);
    }

    @Override
    public boolean registerInterface(Class<?> clazz) {
        return this.defaultContext_.registerInterface((Class)clazz);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.defaultContext_.getInterfaces();
    }

    @Override
    public Class<?>[] registerProvider(Class<?> clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = this.defaultContext_.registerProvider(clazz)) {
            String string = clazz2.getName();
            if (this.contains(string)) continue;
            this.setDefault(string, clazz.getName());
        }
        return classArray;
    }

    @Override
    public void removeListener(ContextListener contextListener) {
        this.defaultContext_.removeListener(contextListener);
    }

    @Override
    public void setAttribute(String string, Object object, Object object2) {
        this.defaultContext_.setAttribute(string, object, object2);
        if (object2 != null) {
            return;
        }
        if (object instanceof Boolean) {
            this.setValue(string, (Boolean)object);
        } else if (object instanceof Double) {
            this.setValue(string, (Double)object);
        } else if (object instanceof Float) {
            this.setValue(string, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.setValue(string, (Long)object);
        } else if (object instanceof Integer) {
            this.setValue(string, (Integer)object);
        } else if (object instanceof int[]) {
            this.setValue(string, this.formatIntArray((int[])object));
        } else if (object instanceof Enum) {
            this.setValue(string, ((Enum)object).name());
        } else if (object instanceof String) {
            this.setValue(string, (String)object);
        } else if (object instanceof Provider) {
            this.setValue(string, object.getClass().getName());
        } else if (object instanceof File) {
            this.setValue(string, ((File)object).getAbsolutePath());
        } else {
            log_s_.warn((Object)this.composeWarnMsgUnknownTypeValue(string, object));
            return;
        }
    }

    @Override
    public void setAttribute(ContextValue contextValue, Object object) {
        ArgumentChecker.throwIfNull((Object)contextValue);
        String string = contextValue.id();
        Object object2 = contextValue.defaultValue();
        this.setAttribute(string, object2, object);
        this.setDefault(string, object2);
    }

    private void setDefault(String string, Object object) {
        if (object instanceof Boolean) {
            this.setDefault(string, (Boolean)object);
        } else if (object instanceof Double) {
            this.setDefault(string, (Double)object);
        } else if (object instanceof Float) {
            this.setDefault(string, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.setDefault(string, (Long)object);
        } else if (object instanceof Integer) {
            this.setDefault(string, (Integer)object);
        } else if (object instanceof Enum) {
            this.setDefault(string, ((Enum)object).name());
        } else if (object instanceof String) {
            this.setDefault(string, (String)object);
        } else if (object instanceof Provider) {
            this.setDefault(string, object.getClass().getName());
        } else if (object instanceof File) {
            this.setDefault(string, ((File)object).getAbsolutePath());
        } else {
            log_s_.warn((Object)this.composeWarnMsgUnknownTypeValue(string, object));
            return;
        }
    }

    @Override
    public String[] rootKeys() {
        return this.defaultContext_.rootKeys();
    }

    @Override
    public void setProvider(Class<?> clazz, Class<?> clazz2, Object object) {
        this.defaultContext_.setProvider(clazz, clazz2, object);
        String string = clazz.getName();
        if (object != null || this.contains(string)) {
            return;
        }
        this.setValue(string, clazz2.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentContextImpl
    implements CurrentContext {
        private final WeakReference<Object> reference_;

        private CurrentContextImpl(Object object) {
            this.reference_ = new WeakReference<Object>(object);
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> clazz) {
            return JFaceContext.this.getProvider(clazz, this.reference_.get());
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> clazz, Provider provider) {
            JFaceContext.this.setAttribute(clazz.getName(), provider, this.reference_.get());
        }

        @Override
        public boolean getBoolean(String string) {
            Object object = JFaceContext.this.getAttribute(string, this.reference_.get());
            if (object == null || !(object instanceof Boolean)) {
                this.throwIllegalStateException(string, object);
            }
            return (Boolean)object;
        }

        @Override
        public boolean getBoolean(BooleanContextValue booleanContextValue) {
            ArgumentChecker.throwIfNull((Object)booleanContextValue);
            Object object = JFaceContext.this.getAttribute(booleanContextValue.id(), this.reference_.get());
            if (object == null || !(object instanceof Boolean)) {
                return booleanContextValue.defaultBoolean();
            }
            return (Boolean)object;
        }

        @Override
        public int getInteger(IntContextValue intContextValue) {
            ArgumentChecker.throwIfNull((Object)intContextValue);
            return this.getInteger(intContextValue.id(), intContextValue.defaultInt());
        }

        @Override
        public int getInteger(String string, int n) {
            Object object = JFaceContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return n;
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                try {
                    return Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    log_s_.warn((Object)("Cant parse value: " + object));
                }
            }
            log_s_.warn((Object)JFaceContext.this.composeMsgMismatchValueType(string, object, int[].class));
            return n;
        }

        @Override
        public void setInteger(String string, int n) {
            JFaceContext.this.setAttribute(string, new Integer(n), this.reference_.get());
        }

        @Override
        public int[] getIntArray(String string, int[] nArray) {
            Object object = JFaceContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return nArray;
            }
            int[] nArray2 = JFaceContext.this.parseIntArray(object);
            if (nArray2 != null) {
                return nArray2;
            }
            log_s_.warn((Object)JFaceContext.this.composeMsgMismatchValueType(string, object, int[].class));
            return nArray;
        }

        @Override
        public int[] getIntArray(IntArrayContextValue intArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)intArrayContextValue);
            return this.getIntArray(intArrayContextValue.id(), intArrayContextValue.defaultIntArray());
        }

        @Override
        public void setIntArray(String string, int[] nArray) {
            ArgumentChecker.throwIfNull((Object)nArray);
            JFaceContext.this.setAttribute(string, nArray, this.reference_.get());
        }

        @Override
        public File getFile(FileContextValue fileContextValue) {
            ArgumentChecker.throwIfNull((Object)fileContextValue);
            Object object = JFaceContext.this.getAttribute(fileContextValue.id(), this.reference_.get());
            if (object == null) {
                return fileContextValue.defaultFile();
            }
            if (object instanceof String) {
                object = new File((String)object);
            }
            if (!(object instanceof File)) {
                log_s_.warn((Object)JFaceContext.this.composeMsgMismatchValueType(fileContextValue.id(), object, File.class));
                return fileContextValue.defaultFile();
            }
            return (File)object;
        }

        @Override
        public void setFile(String string, File file) {
            ArgumentChecker.throwIfNull((Object)file);
            JFaceContext.this.setAttribute(string, file, this.reference_.get());
        }

        private void throwIllegalStateException(String string, Object object) {
            throw new IllegalStateException("Bad value. key='" + string + "', value='" + object + "' " + "class=" + (object == null ? "null" : object.getClass().getName()));
        }
    }
}

