/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.MenuItem;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.act.AboutAction;
import org.unitarou.yukinoshita.view.jface.act.ClearPlPropertyAction;
import org.unitarou.yukinoshita.view.jface.act.ClearTrashCanAction;
import org.unitarou.yukinoshita.view.jface.act.CloseAllTabAction;
import org.unitarou.yukinoshita.view.jface.act.CloseTabAction;
import org.unitarou.yukinoshita.view.jface.act.CopyRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.CreateWindowAction;
import org.unitarou.yukinoshita.view.jface.act.DefaultLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.ExitAction;
import org.unitarou.yukinoshita.view.jface.act.LoadLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.MoveRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.NewDrillFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewGameFileAction;
import org.unitarou.yukinoshita.view.jface.act.NewProblemFileAction;
import org.unitarou.yukinoshita.view.jface.act.OpenFileAction;
import org.unitarou.yukinoshita.view.jface.act.OpenFromClipboard;
import org.unitarou.yukinoshita.view.jface.act.OpenFromWebSite;
import org.unitarou.yukinoshita.view.jface.act.OpenPreferenceAction;
import org.unitarou.yukinoshita.view.jface.act.RedoAction;
import org.unitarou.yukinoshita.view.jface.act.RemoveNodeAction;
import org.unitarou.yukinoshita.view.jface.act.RemoveRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.act.SalvageFromTrashCanAction;
import org.unitarou.yukinoshita.view.jface.act.SaveAction;
import org.unitarou.yukinoshita.view.jface.act.SaveAsAction;
import org.unitarou.yukinoshita.view.jface.act.SaveLayoutAction;
import org.unitarou.yukinoshita.view.jface.act.SelectProviderAction;
import org.unitarou.yukinoshita.view.jface.act.SetMoveValueAction;
import org.unitarou.yukinoshita.view.jface.act.SetPositionValueAction;
import org.unitarou.yukinoshita.view.jface.act.SetVwAtRootAction;
import org.unitarou.yukinoshita.view.jface.act.ShowSgfText;
import org.unitarou.yukinoshita.view.jface.act.UndoAction;
import org.unitarou.yukinoshita.view.jface.act.UnsetVwAtRootAction;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceMenuManager
implements Adaptable {
    private static final MessageResource CLB_FILE = new MessageResource(JFaceMenuManager.class, "clbFile");
    private static final MessageResource CLB_NEW_FILE = new MessageResource(JFaceMenuManager.class, "clbNewFile");
    private static final MessageResource CLB_GAME = new MessageResource(JFaceMenuManager.class, "clbGame");
    private static final MessageResource CLB_PROBLEM = new MessageResource(JFaceMenuManager.class, "clbProblem");
    private static final MessageResource CLB_SIZE_19 = new MessageResource(JFaceMenuManager.class, "clbSize.19");
    private static final MessageResource CLB_SIZE_13 = new MessageResource(JFaceMenuManager.class, "clbSize.13");
    private static final MessageResource CLB_SIZE_9 = new MessageResource(JFaceMenuManager.class, "clbSize.9");
    private static final MessageResource CLB_TRASH_CAN = new MessageResource(JFaceMenuManager.class, "clbTrashCan");
    private static final MessageResource CLB_EDIT = new MessageResource(JFaceMenuManager.class, "clbEdit");
    private static final MessageResource CLB_POSITION = new MessageResource(JFaceMenuManager.class, "clbPosition");
    private static final MessageResource CLB_MOVE = new MessageResource(JFaceMenuManager.class, "clbMove");
    private static final MessageResource CLB_CURRENT_RGT1 = new MessageResource(JFaceMenuManager.class, "clbCurrentRgt1");
    private static final MessageResource CLB_CURRENT_RGT2 = new MessageResource(JFaceMenuManager.class, "clbCurrentRgt2");
    private static final MessageResource CLB_VIEW = new MessageResource(JFaceMenuManager.class, "clbView");
    private static final MessageResource CLB_LAYOUT = new MessageResource(JFaceMenuManager.class, "clbLayout");
    private static final MessageResource CLB_TOOL = new MessageResource(JFaceMenuManager.class, "clbTool");
    private static final MessageResource CLB_HELP = new MessageResource(JFaceMenuManager.class, "clbHelp");
    private static final ProviderInfo[] providerInfos_s_ = new ProviderInfo[]{new ProviderInfo(CoordinatesLabelProvider.class, CoordinatesLabelProvider.CONTEXT.displayName()), new ProviderInfo(StonePainter.class, StonePainter.CONTEXT.displayName()), new ProviderInfo(BlockLabelProvider.class, BlockLabelProvider.CONTEXT.displayName()), new ProviderInfo(VariationLabelProvider.class, VariationLabelProvider.CONTEXT.displayName())};
    private final JFaceWindow window_;
    private final Map<Class, Action> providerMap_;
    private final Map<Class, MenuManager> providerInterfaceMenuMap_;
    private final Adapter adapter_;
    private MenuManager editMenu_;
    private MenuManager rgtEditMenu_;

    public JFaceMenuManager(JFaceWindow jFaceWindow) {
        ArgumentChecker.throwIfNull((Object)jFaceWindow);
        this.window_ = jFaceWindow;
        this.providerMap_ = new HashMap<Class, Action>();
        this.providerInterfaceMenuMap_ = new HashMap<Class, MenuManager>();
        this.adapter_ = new Adapter();
        jFaceWindow.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public void initialize() {
    }

    public void createMenu(MenuManager menuManager) {
        this.createFileMenu(menuManager);
        this.createEditMenu(menuManager);
        this.createViewMenu(menuManager);
        this.createToolMenu(menuManager);
        this.createHelpMenu(menuManager);
    }

    private void createFileMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_FILE.get());
        this.createNewFileMenu(menuManager2);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new OpenFileAction().setController(this.window_));
        menuManager2.add((IAction)new OpenFromClipboard().setController(this.window_));
        menuManager2.add((IAction)new OpenFromWebSite(this.window_));
        menuManager2.add((IAction)new CloseTabAction(this.window_));
        menuManager2.add((IAction)new CloseAllTabAction(this.window_));
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new SaveAction().setController(this.window_));
        menuManager2.add((IAction)new SaveAsAction().setController(this.window_));
        menuManager2.add((IContributionItem)new Separator());
        this.createTrashCanMenu(menuManager2);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new CreateWindowAction());
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new ExitAction());
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createNewFileMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_NEW_FILE.get());
        this.createNewGameFileMenu(menuManager2);
        this.createNewProblemFileMenu(menuManager2);
        menuManager2.add((IAction)new NewDrillFileAction().setController(this.window_));
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createNewGameFileMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_GAME.get());
        MenuManager menuManager3 = new MenuManager(CLB_SIZE_19.get());
        this.createNewGameFileAndHandicapMenu(menuManager3, SgfSize.create(19, 19), 9);
        menuManager2.add((IContributionItem)menuManager3);
        menuManager3 = new MenuManager(CLB_SIZE_13.get());
        this.createNewGameFileAndHandicapMenu(menuManager3, SgfSize.create(13, 13), 6);
        menuManager2.add((IContributionItem)menuManager3);
        menuManager3 = new MenuManager(CLB_SIZE_9.get());
        this.createNewGameFileAndHandicapMenu(menuManager3, SgfSize.create(9, 9), 4);
        menuManager2.add((IContributionItem)menuManager3);
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createNewGameFileAndHandicapMenu(MenuManager menuManager, SgfSize sgfSize, int n) {
        for (int i = 0; i <= n; ++i) {
            menuManager.add((IAction)new NewGameFileAction(sgfSize, i).setController(this.window_));
        }
    }

    private void createNewProblemFileMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_PROBLEM.get());
        MenuManager menuManager3 = new MenuManager(CLB_SIZE_19.get());
        this.createNewProblemFileAndPlayerToPlayMenu(menuManager3, SgfSize.create(19, 19));
        menuManager2.add((IContributionItem)menuManager3);
        menuManager3 = new MenuManager(CLB_SIZE_13.get());
        this.createNewProblemFileAndPlayerToPlayMenu(menuManager3, SgfSize.create(13, 13));
        menuManager2.add((IContributionItem)menuManager3);
        menuManager3 = new MenuManager(CLB_SIZE_9.get());
        this.createNewProblemFileAndPlayerToPlayMenu(menuManager3, SgfSize.create(9, 9));
        menuManager2.add((IContributionItem)menuManager3);
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createNewProblemFileAndPlayerToPlayMenu(MenuManager menuManager, SgfSize sgfSize) {
        menuManager.add((IAction)new NewProblemFileAction(sgfSize, SgfColor.BLACK).setController(this.window_));
        menuManager.add((IAction)new NewProblemFileAction(sgfSize, SgfColor.WHITE).setController(this.window_));
    }

    private void createTrashCanMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_TRASH_CAN.get());
        menuManager2.add((IAction)new SalvageFromTrashCanAction(this.window_));
        menuManager2.add((IAction)new ClearTrashCanAction(this.window_));
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createEditMenu(MenuManager menuManager) {
        this.editMenu_ = new MenuManager(CLB_EDIT.get());
        this.editMenu_.add((IAction)new UndoAction().setController(this.window_));
        this.editMenu_.add((IAction)new RedoAction().setController(this.window_));
        this.editMenu_.add((IContributionItem)new Separator());
        this.createPositionValueMenu(this.editMenu_);
        this.createMoveValueMenu(this.editMenu_);
        this.editMenu_.add((IAction)new ClearPlPropertyAction().setController(this.window_));
        this.editMenu_.add((IAction)new RemoveNodeAction().setController(this.window_));
        this.editMenu_.add((IContributionItem)new Separator());
        this.editMenu_.add((IAction)new SetVwAtRootAction(this.window_));
        this.editMenu_.add((IAction)new UnsetVwAtRootAction(this.window_));
        this.editMenu_.add((IContributionItem)new Separator());
        this.createRootGameTreeEditMenu(this.editMenu_);
        this.editMenu_.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                JFaceMenuManager.this.updateMenu();
            }
        });
        menuManager.add((IContributionItem)this.editMenu_);
    }

    private void createPositionValueMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_POSITION.get());
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_WHITE.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.GOOD_FOR_BLACK.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.EVEN_POSITION.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.UNCLEAR_POS.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.HOTSPOT.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, SgfId.HOTSPOT.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new SetPositionValueAction(this.window_, null));
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createMoveValueMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_MOVE.get());
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.TESUJI.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED)));
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL)));
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.INTERESTING.makeProperty(None.INSTANCE)));
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, SgfId.DOUBTFUL.makeProperty(None.INSTANCE)));
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)new SetMoveValueAction(this.window_, null));
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createRootGameTreeEditMenu(MenuManager menuManager) {
        this.rgtEditMenu_ = new MenuManager(CLB_CURRENT_RGT1.get());
        this.rgtEditMenu_.add((IAction)new CopyRootGameTreeAction(this.window_));
        this.rgtEditMenu_.add((IAction)new MoveRootGameTreeAction(this.window_));
        this.rgtEditMenu_.add((IAction)new RemoveRootGameTreeAction(this.window_));
        menuManager.add((IContributionItem)this.rgtEditMenu_);
    }

    private void createViewMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_VIEW.get());
        for (ProviderInfo providerInfo : providerInfos_s_) {
            this.composeProviderMenu(menuManager2, providerInfo.clazz_, providerInfo.displayName_);
        }
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IContributionItem)this.createLayoutMenu());
        menuManager2.add((IAction)new ShowSgfText(this.window_));
        menuManager2.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                JFaceMenuManager.this.updateMenu();
            }
        });
        menuManager.add((IContributionItem)menuManager2);
    }

    private <T extends Provider> void composeProviderMenu(MenuManager menuManager, Class<T> clazz, String string) {
        MenuManager menuManager2 = new MenuManager(string);
        this.providerInterfaceMenuMap_.put(clazz, menuManager2);
        for (Provider provider : Yukinoshita.context().getProviders(clazz)) {
            SelectProviderAction<Provider> selectProviderAction = new SelectProviderAction<Provider>(clazz, provider);
            selectProviderAction.setController(this.window_);
            menuManager2.add(selectProviderAction);
            this.providerMap_.put(provider.getClass(), selectProviderAction);
        }
        menuManager.add((IContributionItem)menuManager2);
    }

    private MenuManager createLayoutMenu() {
        MenuManager menuManager = new MenuManager(CLB_LAYOUT.get());
        menuManager.add((IAction)new LoadLayoutAction(this.window_));
        menuManager.add((IAction)new DefaultLayoutAction(this.window_));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new SaveLayoutAction(this.window_));
        return menuManager;
    }

    private void createToolMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_TOOL.get());
        menuManager2.add((IAction)new OpenPreferenceAction((JFaceContext)Yukinoshita.context()));
        menuManager.add((IContributionItem)menuManager2);
    }

    private void createHelpMenu(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(CLB_HELP.get());
        menuManager2.add((IAction)new AboutAction());
        menuManager.add((IContributionItem)menuManager2);
    }

    private void updateMenu() {
        String string;
        GameFrameController gameFrameController = this.window_.getActive();
        MenuItem menuItem = this.rgtEditMenu_.getMenu().getParentItem();
        if (gameFrameController == null) {
            menuItem.setText("\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
            menuItem.setEnabled(false);
            return;
        }
        GameMediator gameMediator = gameFrameController.getCollectionEditor().getActiveGame();
        RootGameTree rootGameTree = gameMediator.getRootGameTree();
        RootGameTreeLabelProvider rootGameTreeLabelProvider = RootGameTreeLabelProvider.CONTEXT.defaultProvider();
        String string2 = rootGameTreeLabelProvider.getLabel(rootGameTree);
        if (string2.length() != 0) {
            string = CLB_CURRENT_RGT2.get(rootGameTree.getGameType().displayName(), string2);
        } else {
            rootGameTreeLabelProvider = new GreedyRgtLabelProvider();
            string2 = rootGameTreeLabelProvider.getLabel(rootGameTree);
            string = CLB_CURRENT_RGT1.get((Object)string2);
        }
        menuItem.setText(string);
        menuItem.setEnabled(true);
        for (ProviderInfo providerInfo : providerInfos_s_) {
            this.changeRadioState(gameFrameController, providerInfo.clazz_);
        }
    }

    private <T extends Provider> void changeRadioState(GameFrameController gameFrameController, Class<T> clazz) {
        IAction iAction = (IAction)this.providerMap_.get(gameFrameController.getProvider(clazz).getClass());
        IContributionItem[] iContributionItemArray = this.providerInterfaceMenuMap_.get(clazz).getItems();
        for (int i = 0; i < iContributionItemArray.length; ++i) {
            ((ActionContributionItem)iContributionItemArray[i]).getAction().setChecked(false);
        }
        if (iAction != null) {
            iAction.setChecked(true);
        }
    }

    private class Adapter
    implements NodeMonitor,
    ModelEventNotifier,
    ControllerStatusMonitor,
    WindowControllerListener {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(JFaceMenuManager.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(JFaceMenuManager.this);
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        public void currentChanged(NodeView nodeView) {
            JFaceMenuManager.this.updateMenu();
        }

        public void changeActive(GameFrameController gameFrameController) {
            JFaceMenuManager.this.updateMenu();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderInfo {
        private final Class<? extends Provider> clazz_;
        private final String displayName_;

        private ProviderInfo(Class<? extends Provider> clazz, String string) {
            this.clazz_ = clazz;
            this.displayName_ = string;
        }
    }
}

