/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.WindowController;

public class OpenFromClipboard
extends Action {
    private static final Log log_s_ = LogFactory.getLog(OpenFromClipboard.class);
    private static final MessageResource CLB_NAME = new MessageResource(OpenFromClipboard.class, "clbName");
    private static final MessageResource LB_CLIPBOARD = new MessageResource(OpenFromClipboard.class, "lbClipboard");
    private static final MessageResource NT_CLIPBOARD_READ_FAILURE = new MessageResource(OpenFromClipboard.class, "ntClipboardReadFailure");
    private static final MessageResource MSG_NO_TEXT_CONTENTS = new MessageResource(OpenFromClipboard.class, "msgNoTextContents");
    private static final MessageResource MSG_NO_CONTENTS = new MessageResource(OpenFromClipboard.class, "msgNoContents");
    private static final MessageResource MSG_SGF_PARSE_ERROR = new MessageResource(OpenFromClipboard.class, "msgSgfParseError");
    private WindowController controller_ = null;

    public OpenFromClipboard() {
        this.setText(CLB_NAME.get());
    }

    public OpenFromClipboard setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn((Object)"#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Display display = Display.getCurrent();
        Control control = display.getFocusControl();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace((Object)("Target control: " + control));
        }
        if (this.pasteToControl(control)) {
            return;
        }
        Clipboard clipboard = new Clipboard(display);
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            TransferData[] transferDataArray = clipboard.getAvailableTypes();
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (!textTransfer.isSupportedType(transferDataArray[i])) continue;
                String string = (String)clipboard.getContents((Transfer)textTransfer);
                this.openFromClipboardImpl(string);
                return;
            }
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, NT_CLIPBOARD_READ_FAILURE.get(), MSG_NO_TEXT_CONTENTS.get());
        }
        catch (SgfParserException sgfParserException) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CLIPBOARD_READ_FAILURE.get(), MSG_SGF_PARSE_ERROR.get());
        }
        finally {
            clipboard.dispose();
        }
    }

    private boolean pasteToControl(Control control) {
        Text text;
        if (control == null) {
            return false;
        }
        if (control instanceof Text && (text = (Text)control).getEditable()) {
            text.paste();
            return true;
        }
        if (control instanceof Combo && 0 == ((text = (Combo)control).getStyle() & 8)) {
            text.paste();
            return true;
        }
        return false;
    }

    private void openFromClipboardImpl(String string) throws SgfParserException {
        SgfParser sgfParser = new SgfParser();
        Collection collection = sgfParser.parse(string);
        if (collection.size() == 0) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CLIPBOARD_READ_FAILURE.get(), MSG_NO_CONTENTS.get());
            return;
        }
        this.controller_.register(collection, LB_CLIPBOARD.get(), false);
    }
}

