/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.RedoCommand;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedoAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(RedoAction.class);
    private static final MessageResource CLB_NAME = new MessageResource(RedoAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;

    public RedoAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String string) {
        this.setText(CLB_NAME.get((Object)string));
    }

    public RedoAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    public void run() {
        if (this.controller_ == null) {
            log_s_.warn((Object)"#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        GameFrameController gameFrameController = this.controller_.getActive();
        RedoCommand redoCommand = new RedoCommand();
        gameFrameController.getEventBroker().executeCommand(redoCommand);
        CommandDriver.Status status = gameFrameController.getCollectionEditor().getActiveGame().getCommandDriverStatus();
        if (status.getExecutedCommand() instanceof Command4NodeList) {
            gameFrameController.updateByRedoUndo(((Command4NodeList)status.getExecutedCommand()).getInfluence());
        }
    }

    private class Adapter
    implements CommandDriverMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void commandExecuted(CommandDriver.Status status) {
            ArgumentChecker.throwIfNull((Object)status);
            GameFrameController gameFrameController = this.refGfc_.get();
            if (gameFrameController != null) {
                RedoAction.this.setEnabled(gameFrameController.isEditMode() && status.isRedoable());
                RedoAction.this.setCommandName(status.getRedoName());
            }
        }

        public void changeActive(GameFrameController gameFrameController) {
            GameFrameController gameFrameController2 = this.refGfc_.get();
            if (gameFrameController2 != null) {
                gameFrameController2.getEventBroker().removeView(RedoAction.this);
            }
            this.refGfc_ = new WeakReference<GameFrameController>(gameFrameController);
            if (gameFrameController == null) {
                RedoAction.this.setEnabled(false);
                RedoAction.this.setCommandName("");
                return;
            }
            gameFrameController.getEventBroker().addView(RedoAction.this);
            CommandDriver.Status status = gameFrameController.getCollectionEditor().getActiveGame().getCommandDriverStatus();
            RedoAction.this.setEnabled(gameFrameController.isEditMode() && status.isRedoable());
            RedoAction.this.setCommandName(status.getRedoName());
        }

        public void setEditMode(boolean bl) {
            GameFrameController gameFrameController = this.refGfc_.get();
            if (gameFrameController == null) {
                log_s_.warn((Object)"Lost GameFraemController (BUG)");
                return;
            }
            if (bl) {
                CommandDriver.Status status = gameFrameController.getCollectionEditor().getActiveGame().getCommandDriverStatus();
                RedoAction.this.setEnabled(gameFrameController.isEditMode() && status.isRedoable());
                RedoAction.this.setCommandName(status.getRedoName());
            } else {
                RedoAction.this.setEnabled(false);
                RedoAction.this.setCommandName("");
            }
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

