/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;

public class SalvageFromTrashCanAction
extends AbstractRootGameTreeAction {
    private static final MessageResource NT_SALVAGE_DLG_TITLE = new MessageResource(SalvageFromTrashCanAction.class, "ntSalvageDlgTitle");
    private static final MessageResource MSG_SALVAGE_INSTRACTION = new MessageResource(SalvageFromTrashCanAction.class, "msgSalvageInstraction");
    private static final MessageResource NT_MOVE_DLG_TITLE = new MessageResource(SalvageFromTrashCanAction.class, "ntMoveDlgTitle");
    private static final MessageResource MSG_MOVE_INSTRACTION = new MessageResource(SalvageFromTrashCanAction.class, "msgMoveInstraction");

    public SalvageFromTrashCanAction(WindowController windowController) {
        super(windowController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Collection collection = FileManager.instance().getTrashCan();
        RootGameTreeChooser rootGameTreeChooser = new RootGameTreeChooser(Display.getCurrent().getActiveShell(), collection, RootGameTreeChooser.Style.SINGLE);
        rootGameTreeChooser.setShellTitle(NT_SALVAGE_DLG_TITLE.get());
        rootGameTreeChooser.setTitle(MSG_SALVAGE_INSTRACTION.get());
        if (1 == rootGameTreeChooser.open()) {
            return;
        }
        RootGameTree[] rootGameTreeArray = rootGameTreeChooser.getSelected();
        if (0 == rootGameTreeArray.length) {
            return;
        }
        RootGameTree rootGameTree = rootGameTreeArray[0];
        EnumSet<SelectTargetFileDialog.Type> enumSet = this.getTypes();
        SelectTargetFileDialog selectTargetFileDialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), enumSet);
        String string = rootGameTree.getGameType().displayName();
        selectTargetFileDialog.setShellTitle(NT_MOVE_DLG_TITLE.get((Object)string));
        selectTargetFileDialog.setTitle(MSG_MOVE_INSTRACTION.get((Object)string));
        if (selectTargetFileDialog.open() == 1) {
            return;
        }
        GameFrameController gameFrameController = selectTargetFileDialog.getTarget();
        boolean bl = false;
        try {
            if (gameFrameController == null) {
                Collection collection2 = new Collection();
                collection2.addLast(rootGameTree);
                this.controller_.register(collection2, BasicMessages.LB_NEW_FILE.get(), true);
                this.controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
                bl = true;
                return;
            }
            CollectionEditor collectionEditor = gameFrameController.getCollectionEditor();
            collectionEditor.createGame(rootGameTree);
            this.notifyCollectionViewer(gameFrameController);
            this.changeForLastGame(gameFrameController);
            bl = true;
        }
        finally {
            if (bl) {
                for (int i = 0; i < collection.size(); ++i) {
                    if (!rootGameTree.equals(collection.get(i))) continue;
                    FileManager.instance().pickUp(i);
                    break;
                }
            }
        }
    }

    protected boolean isRunnable(GameFrameController gameFrameController) {
        return true;
    }
}

