/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAsAction.class);
    private static final MessageResource CLB_Name = new MessageResource(SaveAsAction.class, "clbName");
    private WindowController controller_ = null;
    private final Adapter adapter_ = new Adapter();

    public SaveAsAction() {
        this.setText(CLB_Name.get());
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public SaveAsAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    public void run() {
        if (this.controller_ == null) {
            log_s_.warn((Object)"#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control control = Display.getCurrent().getFocusControl();
        control.getParent().forceFocus();
        control.forceFocus();
        GameFrameController gameFrameController = this.controller_.getActive();
        File file = IgoFileDialog.askSaveFile(gameFrameController.getCollection());
        if (file == null) {
            return;
        }
        this.controller_.getActive().getCollection().setFile(file);
        try {
            FileManager.instance().save(gameFrameController.getCollection());
            gameFrameController.clearChangedFlag();
        }
        catch (YukinoshitaException yukinoshitaException) {
            log_s_.error((Object)BasicMessages.NT_FILE_SAVE_FAILURE.get(), (Throwable)yukinoshitaException);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)BasicMessages.NT_FILE_SAVE_FAILURE.get(), (String)yukinoshitaException.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener {
        private Adapter() {
        }

        public void changeActive(GameFrameController gameFrameController) {
            SaveAsAction.this.setEnabled(gameFrameController != null);
        }
    }
}

