/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Result;
import org.unitarou.swt.EnumCombo;
import org.unitarou.yukinoshita.view.jface.ann.Editor;

class ResultEditor
extends Editor {
    private final EnumCombo<Result.Archetype> enumCombo_;
    private Spinner scoreEditor_;
    private final ComboFocusListened comboFocusListened_;
    private final ScoreModifyListened scoreModifyListened_;
    private final ComboModifyListened comboModifyListened_;
    private boolean enableScore_;
    private Result result_;

    ResultEditor() {
        EnumSet<Result.Archetype> enumSet = EnumSet.allOf(Result.Archetype.class);
        enumSet.remove(Result.Archetype.OTHER);
        this.enumCombo_ = new EnumCombo<Result.Archetype>(enumSet, EnumSet.of(EnumCombo.Style.PERMIT_NO_CHOICE));
        this.comboFocusListened_ = new ComboFocusListened();
        this.scoreModifyListened_ = new ScoreModifyListened();
        this.comboModifyListened_ = new ComboModifyListened();
        this.enableScore_ = false;
        this.result_ = new Result(Result.Archetype.OTHER);
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createResultCombo(composite2);
        this.scoreEditor_ = new Spinner(composite2, 2048);
        this.scoreEditor_.addModifyListener((ModifyListener)this.scoreModifyListened_);
        this.scoreEditor_.setEnabled(this.enableScore_);
        this.scoreEditor_.setDigits(1);
        this.scoreEditor_.setSelection(0);
        this.scoreEditor_.setMinimum(0);
        this.scoreEditor_.setMaximum(9999);
        this.scoreEditor_.setIncrement(5);
        this.scoreEditor_.setPageIncrement(10);
        return composite2;
    }

    private void createResultCombo(Composite composite) {
        Label label = new Label(composite, 131072);
        label.setText(SgfId.RESULT.displayName());
        label.setLayoutData((Object)new GridData(128));
        Combo combo = (Combo)this.enumCombo_.createContents(composite);
        combo.addFocusListener((FocusListener)this.comboFocusListened_);
        combo.addModifyListener((ModifyListener)this.comboModifyListened_);
    }

    public void dispose() {
    }

    void setProperty(Property property) {
        if (property == null) {
            this.result_ = new Result(Result.Archetype.OTHER);
            this.enumCombo_.select(null);
            this.scoreEditor_.setSelection(0);
            return;
        }
        String string = property.getString();
        this.result_ = Result.parse(string);
        if (Result.Archetype.OTHER.equals(this.result_.getArchetype())) {
            this.enumCombo_.setText(this.result_.getValue());
        } else {
            this.enumCombo_.select(this.result_.getArchetype());
        }
        this.scoreEditor_.setSelection((int)(this.result_.getScore() * 10.0));
    }

    void setEditable(boolean bl) {
        this.enumCombo_.setEnabled(bl);
        this.scoreEditor_.setEnabled(bl && this.enableScore_);
    }

    String getDatum() {
        Result.Archetype archetype = this.enumCombo_.getSelected();
        if (Result.Archetype.SCORED.contains(archetype)) {
            return archetype.typeName() + String.valueOf((double)this.scoreEditor_.getSelection() / 10.0);
        }
        if (archetype == null) {
            return this.enumCombo_.getText();
        }
        return archetype.typeName().toString();
    }

    private void updateScoreEditorEnabled() {
        Result.Archetype archetype = this.enumCombo_.getSelected();
        if (Result.Archetype.SCORED.contains(archetype)) {
            this.enableScore_ = true;
        } else {
            this.enableScore_ = false;
            this.scoreEditor_.setSelection(0);
        }
        this.scoreEditor_.setEnabled(this.enumCombo_.isEnabled() && this.enableScore_);
    }

    private class ScoreModifyListened
    implements ModifyListener {
        private ScoreModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            int n = (int)(ResultEditor.this.result_.getScore() * 10.0);
            if (ResultEditor.this.scoreEditor_.getSelection() != n) {
                ResultEditor.this.fireModifyText((Widget)ResultEditor.this.enumCombo_.getCombo());
            }
        }
    }

    private class ComboModifyListened
    implements ModifyListener {
        private ComboModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ResultEditor.this.updateScoreEditorEnabled();
        }
    }

    private class ComboFocusListened
    extends FocusAdapter {
        private ComboFocusListened() {
        }

        public void focusLost(FocusEvent focusEvent) {
            ResultEditor.this.updateScoreEditorEnabled();
            ResultEditor.this.fireModifyText((Widget)ResultEditor.this.enumCombo_.getCombo());
        }
    }
}

