/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsPanel<T extends IgoOutlinePanel>
implements WidgetContainer {
    private final IgoOutlinePanelFactory<T> factory_;
    private ScrolledComposite scrolledComposite_;
    private Composite frame_;
    private GridLayout gridLayout_;
    private List<T> list_;

    public CollectionsPanel(IgoOutlinePanelFactory<T> igoOutlinePanelFactory) {
        this(igoOutlinePanelFactory, 4);
    }

    public CollectionsPanel(IgoOutlinePanelFactory<T> igoOutlinePanelFactory, int n) {
        ArgumentChecker.throwIfNull(igoOutlinePanelFactory);
        if (n <= 0) {
            throw new IllegalArgumentException("Bad size of column: " + n);
        }
        this.factory_ = igoOutlinePanelFactory;
        this.scrolledComposite_ = null;
        this.frame_ = null;
        this.gridLayout_ = new GridLayout(n, false);
        this.list_ = new ArrayList<T>();
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        this.scrolledComposite_ = new ScrolledComposite(composite2, 512);
        this.scrolledComposite_.setLayout((Layout)new FillLayout());
        this.scrolledComposite_.setExpandHorizontal(true);
        this.scrolledComposite_.setExpandVertical(false);
        this.scrolledComposite_.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                CollectionsPanel.this.resized();
            }
        });
        this.frame_ = new Composite((Composite)this.scrolledComposite_, 0);
        this.scrolledComposite_.setContent((Control)this.frame_);
        return composite2;
    }

    private void resized() {
        int n;
        Point point = Geometry.getSize((Rectangle)this.scrolledComposite_.getClientArea());
        point.x = n = point.x / this.gridLayout_.numColumns - (this.gridLayout_.horizontalSpacing * 2 + this.frame_.getBorderWidth());
        point.y = n;
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.setBoardSize(point);
        }
        this.frame_.pack();
    }

    @Override
    public void dispose() {
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.dispose();
        }
    }

    public void set(Collection[] collectionArray) {
        ArgumentChecker.throwIfNull((Object)collectionArray);
        this.frame_.dispose();
        for (Collection[] collectionArray2 : this.list_) {
            collectionArray2.dispose();
        }
        this.list_.clear();
        this.frame_ = new Composite((Composite)this.scrolledComposite_, 0);
        this.frame_.setLayout((Layout)this.gridLayout_);
        int n = 0;
        for (Collection collection : collectionArray) {
            n += collection.size();
        }
        for (Collection collection : collectionArray) {
            for (int i = 0; i < collection.size(); ++i) {
                T t = this.factory_.create();
                Control control = ((IgoOutlinePanel)t).createContents(this.frame_);
                GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
                control.setLayoutData((Object)gridData);
                ((IgoOutlinePanel)t).setRootGameTree(collection.get(i));
                this.list_.add(t);
            }
        }
        this.resized();
        this.scrolledComposite_.setContent((Control)this.frame_);
        this.scrolledComposite_.setMinSize(this.frame_.getSize());
    }

    public T[] getPanels(T[] TArray) {
        return (IgoOutlinePanel[])this.list_.toArray(TArray);
    }

    protected Composite getFrame() {
        return this.frame_;
    }

    protected void setFocus(RootGameTree rootGameTree) {
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.setFocus(rootGameTree.equals(igoOutlinePanel.getRootGameTree()));
        }
    }

    protected void setFocus(Collection collection) {
        IgoOutlinePanel igoOutlinePanel2;
        ArgumentChecker.throwIfNull((Object)collection);
        HashSet<RootGameTree> hashSet = new HashSet<RootGameTree>();
        for (int i = 0; i < collection.size(); ++i) {
            hashSet.add(collection.get(i));
        }
        Point point = this.frame_.getSize();
        Point point2 = new Point(0, 0);
        for (IgoOutlinePanel igoOutlinePanel2 : this.list_) {
            boolean bl = hashSet.contains(igoOutlinePanel2.getRootGameTree());
            igoOutlinePanel2.setFocus(bl);
            if (!bl) continue;
            Control control = igoOutlinePanel2.getControl();
            Point point3 = control.getLocation();
            Point point4 = Geometry.add((Point)point3, (Point)control.getSize());
            point = Geometry.min((Point)point, (Point)point3);
            point2 = Geometry.max((Point)point2, (Point)point4);
        }
        Point point5 = this.scrolledComposite_.getOrigin();
        igoOutlinePanel2 = Geometry.getSize((Rectangle)this.scrolledComposite_.getClientArea());
        if (point.y < point5.y) {
            this.scrolledComposite_.setOrigin(point);
        } else if (point5.y + ((Point)igoOutlinePanel2).y < point2.y) {
            Point point6 = Geometry.subtract((Point)point2, (Point)igoOutlinePanel2);
            this.scrolledComposite_.setOrigin(point6);
        }
    }
}

