/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.crdlp.NoCoordinatesProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoGraphicalBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.blklp.NoBlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgoOutlinePanel
implements WidgetContainer {
    private static Object scopeKey_s_ = new Object();
    private static BlockLabelProvider blockLabelProvider_s_ = new NoBlockLabelProvider();
    private static CoordinatesLabelProvider coordinatesLabelProvider_s_ = new NoCoordinatesProvider();
    private static VariationLabelProvider variationLabelProvider_s_ = new NoVariationProvider();
    private Composite frame_;
    private final Alignment alignment_;
    private Label annotationLabel_;
    private final IgoBoardPanel igoBoardPanel_;
    private Control boardControl_;
    private Point boardSize_;
    private RootGameTree rootGameTree_;
    private EditableNodeList editableNodeList_;
    private boolean isFocused_;

    public static IgoOutlinePanelFactory<IgoOutlinePanel> factory() {
        return new FactoryImpl();
    }

    public IgoOutlinePanel() {
        this(Alignment.BOTTOM);
    }

    public IgoOutlinePanel(Alignment alignment) {
        ArgumentChecker.throwIfNull((Object)alignment);
        this.alignment_ = alignment;
        this.igoBoardPanel_ = new IgoGraphicalBoardPanel();
        this.boardSize_ = new Point(150, 150);
        this.isFocused_ = false;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        switch (this.alignment_) {
            case TOP: {
                this.frame_.setLayout((Layout)new GridLayout(1, true));
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData((Object)new GridData(0x1000000, 1024, true, true));
                this.boardControl_ = this.igoBoardPanel_.createContents(this.frame_);
                break;
            }
            case BOTTOM: {
                this.frame_.setLayout((Layout)new GridLayout(1, true));
                this.boardControl_ = this.igoBoardPanel_.createContents(this.frame_);
                this.annotationLabel_ = new Label(this.frame_, 0x1000040);
                this.annotationLabel_.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
                break;
            }
            case LEFT: {
                this.frame_.setLayout((Layout)new GridLayout(1, false));
                this.boardControl_ = this.igoBoardPanel_.createContents(this.frame_);
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData((Object)new GridData(131072, 128, true, true));
                break;
            }
            case RIGHT: {
                this.frame_.setLayout((Layout)new GridLayout(1, false));
                this.annotationLabel_ = new Label(this.frame_, 64);
                this.annotationLabel_.setLayoutData((Object)new GridData(16384, 128, true, true));
                this.boardControl_ = this.igoBoardPanel_.createContents(this.frame_);
                this.igoBoardPanel_.createContents(this.frame_);
                break;
            }
            default: {
                assert (false) : "Unknown alignment type :" + (Object)((Object)this.alignment_);
                break;
            }
        }
        GridData gridData = new GridData(0x1000000, 4, true, true);
        gridData.widthHint = this.boardSize_.x;
        gridData.heightHint = this.boardSize_.y;
        this.boardControl_.setLayoutData((Object)gridData);
        return this.frame_;
    }

    public Control getControl() {
        return this.frame_;
    }

    public Control getBoardControl() {
        return this.boardControl_;
    }

    @Override
    public void dispose() {
    }

    public void setRootGameTree(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.rootGameTree_ == rootGameTree) {
            return;
        }
        this.rootGameTree_ = rootGameTree;
        CurrentContext currentContext = Yukinoshita.context().getCurrent(scopeKey_s_);
        currentContext.setProvider(BlockLabelProvider.class, blockLabelProvider_s_);
        currentContext.setProvider(CoordinatesLabelProvider.class, coordinatesLabelProvider_s_);
        currentContext.setProvider(VariationLabelProvider.class, variationLabelProvider_s_);
        this.igoBoardPanel_.setContext(currentContext);
        this.editableNodeList_ = new EditableNodeList(this.rootGameTree_);
        this.annotationLabel_.setText(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel(this.rootGameTree_));
        if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
            this.igoBoardPanel_.update(this.editableNodeList_.getLastNodeView());
            return;
        }
        for (int i = 0; i < this.editableNodeList_.size(); ++i) {
            NodeEntity nodeEntity = this.editableNodeList_.get(i);
            if (!nodeEntity.getNode().contains(PropertyType.MOVE)) continue;
            i = i != 0 ? i - 1 : i;
            this.igoBoardPanel_.update(this.editableNodeList_.getNodeView(i));
            return;
        }
        if (0 != this.editableNodeList_.size()) {
            this.igoBoardPanel_.update(this.editableNodeList_.getNodeView(this.editableNodeList_.size() - 1));
        }
    }

    public void setBoardSize(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        this.boardSize_ = point;
        GridData gridData = (GridData)this.frame_.getLayoutData();
        gridData.widthHint = this.boardSize_.x;
        gridData = (GridData)this.boardControl_.getLayoutData();
        gridData.widthHint = this.boardSize_.x - this.frame_.getBorderWidth() * 2;
        gridData.heightHint = this.boardSize_.y - this.frame_.getBorderWidth() * 2;
        gridData = (GridData)this.annotationLabel_.getLayoutData();
        gridData.widthHint = this.boardSize_.x - this.frame_.getBorderWidth() * 2;
    }

    public RootGameTree getRootGameTree() {
        return this.rootGameTree_;
    }

    public boolean isFocused() {
        return this.isFocused_;
    }

    public void setFocus(boolean bl) {
        this.isFocused_ = bl;
        Display display = this.frame_.getDisplay();
        this.frame_.setBackground(display.getSystemColor(bl ? 26 : 22));
        this.annotationLabel_.setBackground(display.getSystemColor(bl ? 26 : 22));
        this.annotationLabel_.setForeground(display.getSystemColor(bl ? 27 : 21));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryImpl
    implements IgoOutlinePanelFactory<IgoOutlinePanel> {
        private FactoryImpl() {
        }

        @Override
        public IgoOutlinePanel create() {
            return new IgoOutlinePanel();
        }
    }
}

