/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRuledLinePainter
implements RuledLinePainter {
    private static final ColorResource COLOR_RULEDLINE = new ColorResource(0, 0, 0);
    private static final ColorResource COLOR_STAR = new ColorResource(0, 0, 0);
    private static final double RADIUS_STAR = 0.1;
    private static final int SIZE_THRESHOLD_RULEDLINE = 5;
    private static final int SIZE_THRESHOLD_SINGLE_LINE = 10;
    private static final double[] LEFT_POS = new double[]{0.5, 0.5, 0.0, 0.5};
    private static final double[] RIGHT_POS = new double[]{1.0, 0.5, 0.5, 0.5};
    private static final double[] UP_POS = new double[]{0.5, 0.0, 0.5, 0.5};
    private static final double[] DOWN_POS = new double[]{0.5, 0.5, 0.5, 1.0};
    private static final double[] LEFT_OUTER = new double[]{0.0, 0.0, 0.0, 1.0};
    private static final double[] RIGHT_OUTER = new double[]{1.0, 0.0, 1.0, 1.0};
    private static final double[] UP_OUTER = new double[]{0.0, 0.0, 1.0, 0.0};
    private static final double[] DOWN_OUTER = new double[]{0.0, 1.0, 1.0, 1.0};
    private static final Map<SgfPointType, double[][]> pt2PossitionMap_s_ = new HashMap<SgfPointType, double[][]>(9);
    private static final Map<SgfPointType, int[]> pt2LineWidthMap_s_ = new HashMap<SgfPointType, int[]>(9);
    private boolean isFirst_ = true;

    @Override
    public void paint(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        this.drawRuledLine(gC, sgfPoint, rectangle);
        this.drawStar(gC, sgfPoint, rectangle);
    }

    private void drawRuledLine(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        int n = Math.min(rectangle.width, rectangle.height);
        if (n < 5) {
            return;
        }
        SgfPointType sgfPointType = SgfPointType.classify(sgfPoint);
        int[][] nArray = this.createLinePossition(sgfPointType, rectangle);
        int[] nArray2 = pt2LineWidthMap_s_.get((Object)sgfPointType);
        gC.setLineStyle(1);
        gC.setForeground(COLOR_RULEDLINE.get());
        for (int i = 0; i < nArray.length; ++i) {
            gC.setLineWidth(n < 10 ? 1 : nArray2[i]);
            gC.drawLine(nArray[i][0], nArray[i][1], nArray[i][2], nArray[i][3]);
        }
    }

    private int[][] createLinePossition(SgfPointType sgfPointType, Rectangle rectangle) {
        double[][] dArray = pt2PossitionMap_s_.get((Object)sgfPointType);
        int[][] nArrayArray = new int[dArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[dArray[i].length];
            for (int j = 0; j < nArrayArray[i].length; j += 2) {
                nArrayArray[i][j] = (int)(dArray[i][j] * (double)rectangle.width + (double)rectangle.x);
                nArrayArray[i][j + 1] = (int)(dArray[i][j + 1] * (double)rectangle.height + (double)rectangle.y);
            }
        }
        return nArrayArray;
    }

    private void drawStar(GC gC, SgfPoint sgfPoint, Rectangle rectangle) {
        if (!sgfPoint.size().isStarPoint(sgfPoint)) {
            return;
        }
        int n = (int)((double)rectangle.width * 0.1);
        if (n < 1) {
            return;
        }
        gC.setForeground(COLOR_STAR.get());
        gC.setBackground(COLOR_STAR.get());
        gC.fillOval(rectangle.x + rectangle.width / 2 - n, rectangle.y + rectangle.height / 2 - n, n * 2 + 1, n * 2 + 1);
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView nodeView) {
        if (this.isFirst_) {
            this.isFirst_ = false;
            return nodeView.getSize().all();
        }
        return BlockPainter.EMPTY_SET;
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        return BlockPainter.EMPTY_SET;
    }

    static {
        pt2PossitionMap_s_.put(SgfPointType.TOP_LEFT, new double[][]{RIGHT_POS, DOWN_POS, LEFT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.TOP, new double[][]{LEFT_POS, RIGHT_POS, DOWN_POS, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.TOP_RIGHT, new double[][]{LEFT_POS, DOWN_POS, RIGHT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_RIGHT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.LEFT, new double[][]{UP_POS, DOWN_POS, RIGHT_POS, LEFT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.EMPTY, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_POS});
        pt2LineWidthMap_s_.put(SgfPointType.EMPTY, new int[]{1, 1, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.RIGHT, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.RIGHT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_LEFT, new double[][]{RIGHT_POS, UP_POS, LEFT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_LEFT, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM, new double[][]{LEFT_POS, RIGHT_POS, UP_POS, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM, new int[]{2, 2, 1, 1});
        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_RIGHT, new double[][]{LEFT_POS, UP_POS, RIGHT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_RIGHT, new int[]{2, 2, 1, 1});
    }
}

