/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;

public abstract class CanvasHookedStateHandler
implements Adaptable,
StateHandler {
    private static final char[] variationKeys_s_ = new char[26];
    private final IgoBoardPanel igoBoardPanel_;
    private EventBroker eventBroker_;
    private final ListenerForCanvas listenerForCanvas_;
    private final Map<HandlerPhase, EventDelegator> eventDelegatorMap_;
    private EventDelegator eventDelegator_;
    private BlockStatus blockStatus_;

    protected CanvasHookedStateHandler(IgoBoardPanel igoBoardPanel) {
        ArgumentChecker.throwIfNull((Object)igoBoardPanel);
        this.igoBoardPanel_ = igoBoardPanel;
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.listenerForCanvas_ = new ListenerForCanvas();
        this.eventDelegatorMap_ = new LinkedHashMap<HandlerPhase, EventDelegator>();
        this.eventDelegator_ = null;
        this.blockStatus_ = new BlockStatus();
    }

    protected final IgoBoardPanel getIgoBoardPanel() {
        return this.igoBoardPanel_;
    }

    protected final EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    protected final void registerDelegator(HandlerPhase handlerPhase, EventDelegator eventDelegator) {
        ArgumentChecker.throwIfNull((Object)handlerPhase, (Object)eventDelegator);
        this.eventDelegatorMap_.put(handlerPhase, eventDelegator);
    }

    protected final EventDelegator findDelegator(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        return this.eventDelegatorMap_.get(handlerPhase);
    }

    protected final EventDelegator getEventDelegator() {
        return this.eventDelegator_;
    }

    protected final void setEventDelegator(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        this.eventDelegator_ = this.findDelegator(handlerPhase);
    }

    protected final BlockStatus getBlockStatus() {
        return this.blockStatus_;
    }

    protected final MouseEvent getMouseEvent() {
        return this.listenerForCanvas_.lastMouseEvent_;
    }

    public HandlerPhase[] getHandlerPhases() {
        return this.eventDelegatorMap_.keySet().toArray(new HandlerPhase[this.eventDelegatorMap_.size()]);
    }

    public final void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
    }

    public final void connect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.addMouseListener((MouseListener)this.listenerForCanvas_);
        canvas.addMouseMoveListener((MouseMoveListener)this.listenerForCanvas_);
        canvas.addMouseTrackListener((MouseTrackListener)this.listenerForCanvas_);
        canvas.addKeyListener((KeyListener)this.listenerForCanvas_);
        canvas.addFocusListener((FocusListener)this.listenerForCanvas_);
        canvas.addListener(37, (Listener)this.listenerForCanvas_);
        this.eventBroker_.addView(this);
    }

    public final void disconnect() {
        Canvas canvas = this.igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed.");
        }
        canvas.removeMouseListener((MouseListener)this.listenerForCanvas_);
        canvas.removeMouseMoveListener((MouseMoveListener)this.listenerForCanvas_);
        canvas.removeMouseTrackListener((MouseTrackListener)this.listenerForCanvas_);
        canvas.removeKeyListener((KeyListener)this.listenerForCanvas_);
        canvas.removeListener(37, (Listener)this.listenerForCanvas_);
        this.eventBroker_.removeView(this);
    }

    private void updateBlockStatus(MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)mouseEvent);
        this.blockStatus_ = this.igoBoardPanel_.getBlockStatus(new Point(mouseEvent.x, mouseEvent.y));
        this.updateBlockSituation(mouseEvent);
    }

    protected final void updateBlockSituation(MouseEvent mouseEvent) {
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        BlockSituation blockSituation = this.eventDelegator_.getBlockSituation(this.igoBoardPanel_.getNodeView(), this.blockStatus_, mouseEvent);
        this.igoBoardPanel_.getCanvas().setCursor(blockSituation.getCursor());
        this.igoBoardPanel_.paintInTransient(blockSituation.getTransientProperty());
    }

    protected final void mouseButtonUp(MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)mouseEvent);
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        if (this.eventDelegator_.executeEvent(this.igoBoardPanel_.getNodeView(), this.blockStatus_, mouseEvent, this.eventBroker_)) {
            this.updateBlockStatus(mouseEvent);
        }
    }

    protected void updateKey(int n) {
        if (this.eventDelegator_ == null) {
            throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before.");
        }
        this.eventDelegator_.updateKey(this.igoBoardPanel_.getNodeView(), this.eventBroker_, n);
    }

    protected void changeVariation(int n) {
        NodeView[] nodeViewArray = this.igoBoardPanel_.getNodeView().getVariations();
        for (int i = 0; i < nodeViewArray.length; ++i) {
            if (n != variationKeys_s_[i]) continue;
            this.eventBroker_.executeCommand(new SelectVariation(i));
            return;
        }
    }

    protected void mouseWheel(int n) {
    }

    static {
        CanvasHookedStateHandler.variationKeys_s_[0] = 32;
        for (int i = 1; i < variationKeys_s_.length; ++i) {
            CanvasHookedStateHandler.variationKeys_s_[i] = (char)(97 + i - 1);
        }
    }

    private class ListenerForCanvas
    extends MouseAdapter
    implements MouseMoveListener,
    MouseTrackListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control lastFocused_ = null;
        private MouseEvent lastMouseEvent_ = null;

        private ListenerForCanvas() {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            CanvasHookedStateHandler.this.mouseButtonUp(mouseEvent);
        }

        public void mouseMove(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            CanvasHookedStateHandler.this.updateBlockStatus(mouseEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            CanvasHookedStateHandler.this.updateKey(keyEvent.stateMask | keyEvent.keyCode);
        }

        public void keyReleased(KeyEvent keyEvent) {
            CanvasHookedStateHandler.this.updateKey(keyEvent.stateMask ^ keyEvent.keyCode);
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            Canvas canvas = (Canvas)mouseEvent.widget;
            if (canvas.getShell() == Display.getCurrent().getActiveShell()) {
                this.lastFocused_ = Display.getCurrent().getFocusControl();
                canvas.forceFocus();
            } else {
                this.lastFocused_ = null;
            }
        }

        public void mouseExit(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
            if (this.lastFocused_ != null) {
                this.lastFocused_.forceFocus();
                this.lastFocused_ = null;
            }
        }

        public void mouseHover(MouseEvent mouseEvent) {
            this.lastMouseEvent_ = mouseEvent;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            BlockSituation blockSituation = new BlockSituation();
            CanvasHookedStateHandler.this.igoBoardPanel_.getCanvas().setCursor(blockSituation.getCursor());
            CanvasHookedStateHandler.this.igoBoardPanel_.paintInTransient(blockSituation.getTransientProperty());
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 37: {
                    CanvasHookedStateHandler.this.mouseWheel(-event.count);
                }
            }
        }
    }
}

