/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class CrossPainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(0, 153, 0);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.4;
    private static double lineRatio_s_ = 0.1;

    public static void setSizeRatio(double d) {
        sizeRatio_s_ = d;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    CrossPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData createImageData() {
        Image image = null;
        GC gC = null;
        try {
            Point point = this.getSize();
            image = new Image(null, point.x, point.y);
            gC = new GC((Drawable)image);
            Rectangle rectangle = Geometry.createRectangle((Point)new Point(0, 0), (Point)point);
            rectangle = Rectangles.createScaled(rectangle, sizeRatio_s_);
            gC.setBackground(TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            gC.setLineWidth(Rectangles.resize(point.x, lineRatio_s_, 1, Integer.MAX_VALUE));
            gC.setLineStyle(1);
            gC.setForeground(BODY.get());
            gC.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            gC.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.getPixel(0, 0);
            ImageData imageData2 = imageData;
            return imageData2;
        }
        finally {
            if (gC != null) {
                gC.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

