/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;
import org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter;

class TrianglePainter
extends AbstractPainter {
    private static final ColorResource BODY = new ColorResource(0, 153, 0);
    private static final ColorResource BORDER = new ColorResource(0, 102, 0);
    private static final ColorResource TRANSPARENT = new ColorResource(0, 255, 0);
    private static double sizeRatio_s_ = 0.6;

    public static void setSizeRatio(double d) {
        sizeRatio_s_ = d;
    }

    public static double getSizeRatio() {
        return sizeRatio_s_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageData createImageData() {
        Image image = null;
        GC gC = null;
        try {
            Point point = this.getSize();
            image = new Image(null, point.x, point.y);
            gC = new GC((Drawable)image);
            Rectangle rectangle = Geometry.createRectangle((Point)new Point(0, 0), (Point)point);
            rectangle = Rectangles.createScaled(rectangle, sizeRatio_s_);
            gC.setBackground(TRANSPARENT.get());
            gC.fillRectangle(image.getBounds());
            int n = rectangle.height / 2;
            Point point2 = new Point(rectangle.x + n, rectangle.y + n);
            Point point3 = new Point((int)(Math.cos(0.5235987755982988) * (double)n), (int)(Math.sin(0.5235987755982988) * (double)n));
            Point point4 = new Point(point2.x - point3.x, point2.y + point3.y);
            Point point5 = new Point(point2.x + point3.x, point2.y + point3.y);
            int[] nArray = new int[]{rectangle.x + n, rectangle.y, point4.x, point4.y, point5.x, point5.y};
            gC.setBackground(BODY.get());
            gC.fillPolygon(nArray);
            gC.setLineWidth(1);
            gC.setLineStyle(1);
            gC.setForeground(BORDER.get());
            gC.drawPolygon(nArray);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.getPixel(0, 0);
            ImageData imageData2 = imageData;
            return imageData2;
        }
        finally {
            if (gC != null) {
                gC.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

