/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.util.filter.InsertLineSeparatorFilter;
import org.unitarou.sgf.util.filter.RemoveSoftLineBreakFilter;
import org.unitarou.sgf.util.filter.RemoveUtrFilter;
import org.unitarou.sgf.util.filter.SieveBySgfIdFilter;
import org.unitarou.swt.EnumCombo;
import org.unitarou.swt.EnumSelectionAdapter;
import org.unitarou.swt.EnumSelectionListener;
import org.unitarou.swt.LabeledEnumCombo;
import org.unitarou.swt.Swts;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfTextDialog
extends Dialog {
    private static final int COPY_ID = 1024;
    private static final int CANCEL_ID = 1;
    private static final MessageResource LB_DIALOG_TITLE = new MessageResource(SgfTextDialog.class, "lbDialogTitle");
    private static final MessageResource CLB_COPY = new MessageResource(SgfTextDialog.class, "clbCopy");
    private static final MessageResource CLB_GROUP_FILTER_OPTION = new MessageResource(SgfTextDialog.class, "clbGroupFilterOption");
    private static final MessageResource CLB_UTR_COMBO = new MessageResource(SgfTextDialog.class, "clbUtrCombo");
    private static final MessageResource CLB_SGFID_OPTION = new MessageResource(SgfTextDialog.class, "clbSgfidOption");
    private static final MessageResource LB_LINE_SIZE = new MessageResource(SgfTextDialog.class, "lbLineSize");
    private static final Set<SgfId> requisiteIds_;
    private final org.unitarou.sgf.Collection collection_;
    private final int activeGameIndex_;
    private SgfId[] sgfIds_;
    private RemoveUtrFilter.Option utrType_;
    private final EnumSet<InsertLineSeparatorFilter.Option> slbOptions_;
    private LabeledEnumCombo<RemoveUtrFilter.Option> utrCombo_;
    private LabeledEnumCombo<HandleSgfId> sgfIdCombo_;
    private Text text_;
    private CheckboxTableViewer rgtViewer_;
    private CheckboxTableViewer sgfIdViewer_;
    private Label lbLineSize_;
    private Scale scale_;

    public SgfTextDialog(Shell shell, org.unitarou.sgf.Collection collection, int n) {
        super(shell);
        ArgumentChecker.throwIfNull((Object)collection);
        ArgumentChecker.throwIfNegative(n);
        this.setShellStyle(65584);
        this.collection_ = collection;
        this.activeGameIndex_ = n;
        this.utrType_ = RemoveUtrFilter.Option.REMOVE_ALL;
        this.slbOptions_ = EnumSet.noneOf(InsertLineSeparatorFilter.Option.class);
        this.utrCombo_ = new LabeledEnumCombo<RemoveUtrFilter.Option>(EnumSet.allOf(RemoveUtrFilter.Option.class), EnumSet.of(EnumCombo.Style.READ_ONLY));
        this.utrCombo_.setText(CLB_UTR_COMBO.get());
        this.utrCombo_.addListener((EnumSelectionListener<RemoveUtrFilter.Option>)new EnumSelectionAdapter<RemoveUtrFilter.Option>(){

            @Override
            public void itemSelected(RemoveUtrFilter.Option option) {
                SgfTextDialog.this.utrType_ = option;
                SgfTextDialog.this.updateText();
            }
        });
        this.sgfIdCombo_ = new LabeledEnumCombo<HandleSgfId>(EnumSet.allOf(HandleSgfId.class), EnumSet.of(EnumCombo.Style.READ_ONLY));
        this.sgfIdCombo_.setText(CLB_SGFID_OPTION.get());
        this.sgfIdCombo_.addListener((EnumSelectionListener<HandleSgfId>)new EnumSelectionAdapter<HandleSgfId>(){

            @Override
            public void itemSelected(HandleSgfId handleSgfId) {
                SgfTextDialog.this.updateSgfIdType(handleSgfId);
                SgfTextDialog.this.updateText();
            }
        });
        this.text_ = null;
        this.rgtViewer_ = null;
        this.sgfIdViewer_ = null;
        this.lbLineSize_ = null;
        this.scale_ = null;
        HashSet<SgfId> hashSet = new HashSet<SgfId>();
        for (RootGameTree rootGameTree : this.collection_) {
            this.addAllSgfId(rootGameTree, hashSet);
        }
        this.sgfIds_ = hashSet.toArray(new SgfId[hashSet.size()]);
        Arrays.sort(this.sgfIds_);
    }

    private void updateSgfIdType(HandleSgfId handleSgfId) {
        switch (handleSgfId) {
            case MANUAL: {
                for (TableItem tableItem : this.sgfIdViewer_.getTable().getItems()) {
                    tableItem.setGrayed(false);
                }
                break;
            }
            case ALL: {
                for (TableItem tableItem : this.sgfIdViewer_.getTable().getItems()) {
                    tableItem.setChecked(true);
                    tableItem.setGrayed(true);
                }
                break;
            }
            case REQUISITE: {
                for (TableItem tableItem : this.sgfIdViewer_.getTable().getItems()) {
                    tableItem.setChecked(requisiteIds_.contains(tableItem.getData()));
                    tableItem.setGrayed(true);
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void updateSgfIds() {
        Object object3;
        Object object22;
        org.unitarou.sgf.Collection collection = new org.unitarou.sgf.Collection();
        for (Object object22 : this.collection_) {
            if (!this.rgtViewer_.getChecked(object22)) continue;
            collection.addLast((RootGameTree)object22);
        }
        HashSet hashSet = new HashSet();
        for (Object object3 : collection) {
            this.addAllSgfId((GameTree)object3, hashSet);
        }
        object22 = new HashSet<SgfId>(Arrays.asList(this.sgfIds_));
        object22.removeAll(Arrays.asList(this.sgfIdViewer_.getCheckedElements()));
        this.sgfIdViewer_.remove((Object[])this.sgfIds_);
        this.sgfIds_ = hashSet.toArray(new SgfId[hashSet.size()]);
        Arrays.sort(this.sgfIds_);
        this.sgfIdViewer_.add((Object[])this.sgfIds_);
        object3 = new HashSet<SgfId>(Arrays.asList(this.sgfIds_));
        object3.removeAll((Collection<?>)object22);
        this.sgfIdViewer_.setCheckedElements(object3.toArray());
        this.updateSgfIdType((HandleSgfId)((Object)this.sgfIdCombo_.getSelected()));
    }

    private void addAllSgfId(GameTree gameTree, Set<SgfId> set) {
        for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                set.add(property.sgfId());
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.addAllSgfId(gameTree2, set);
        }
    }

    private void updateText() {
        Object object2;
        ArrayList<SgfId> arrayList = new ArrayList<SgfId>();
        for (Object object2 : this.sgfIdViewer_.getCheckedElements()) {
            arrayList.add((SgfId)object2);
        }
        Object[] objectArray = arrayList.toArray(new SgfId[arrayList.size()]);
        org.unitarou.sgf.Collection collection = new org.unitarou.sgf.Collection();
        for (int i = 0; i < this.collection_.size(); ++i) {
            if (!this.rgtViewer_.getChecked((Object)this.collection_.get(i))) continue;
            collection.addLast(this.collection_.get(i));
        }
        Object object3 = new RemoveSoftLineBreakFilter(new SieveBySgfIdFilter((SgfId[])objectArray));
        object2 = new RemoveUtrFilter((Filter<org.unitarou.sgf.Collection>)object3);
        ((RemoveUtrFilter)object2).setOption(this.utrType_);
        object3 = object2;
        object2 = new InsertLineSeparatorFilter((Filter<org.unitarou.sgf.Collection>)object3, this.scale_.getSelection());
        ((InsertLineSeparatorFilter)object2).setOption(this.slbOptions_);
        object3 = object2;
        collection = object3.filter(collection);
        String string = new SgfFormatter().formatAsString(collection);
        this.text_.setText(Swts.toWidgetText(string));
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(LB_DIALOG_TITLE.get());
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.heightHint = 480;
        gridData.widthHint = 640;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createTextArea(composite2);
        this.createSliderArea(composite2);
        this.updateText();
        return composite2;
    }

    private void createTextArea(Composite composite) {
        USashForm uSashForm = WidgetFactory.createUSashForm(composite, 256);
        GridData gridData = new GridData(4, 4, true, true);
        uSashForm.setLayoutData(gridData);
        this.text_ = new Text((Composite)uSashForm, 2818);
        this.createControlArea(uSashForm);
        uSashForm.setWeights(new int[]{1, -220});
    }

    private void createControlArea(Composite composite) {
        USashForm uSashForm = WidgetFactory.createUSashForm(composite, 512);
        Composite composite2 = new Composite((Composite)uSashForm, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.rgtViewer_ = CheckboxTableViewer.newCheckList((Composite)composite2, (int)68356);
        this.rgtViewer_.setLabelProvider((IBaseLabelProvider)new RgtLabelProvider());
        for (int i = 0; i < this.collection_.size(); ++i) {
            RootGameTree rootGameTree = this.collection_.get(i);
            this.rgtViewer_.add((Object)rootGameTree);
            if (i != this.activeGameIndex_) continue;
            this.rgtViewer_.setChecked((Object)rootGameTree, true);
        }
        GridData gridData = new GridData(4, 4, true, true);
        this.rgtViewer_.getTable().setLayoutData((Object)gridData);
        this.rgtViewer_.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                SgfTextDialog.this.updateSgfIds();
                SgfTextDialog.this.updateText();
            }
        });
        this.createFilterControllerArea(composite2);
        this.createSgfIdControllerArea(uSashForm);
        uSashForm.setWeights(new int[]{2, 3});
    }

    private void createFilterControllerArea(Composite composite) {
        Group group = new Group(composite, 16);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)gridData);
        group.setText(CLB_GROUP_FILTER_OPTION.get());
        group.setLayout((Layout)new RowLayout(512));
        this.utrCombo_.createContents((Composite)group);
        this.utrCombo_.select(this.utrType_);
        this.createUseSlb((Composite)group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_TEXT);
        this.createUseSlb((Composite)group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_SIMPLETEXT);
    }

    private void createUseSlb(Composite composite, final InsertLineSeparatorFilter.Option option) {
        final Button button = new Button(composite, 32);
        button.setText(option.toString());
        button.setSelection(this.slbOptions_.contains((Object)option));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button.getSelection()) {
                    SgfTextDialog.this.slbOptions_.add(option);
                } else {
                    SgfTextDialog.this.slbOptions_.remove((Object)option);
                }
                SgfTextDialog.this.updateText();
            }
        });
    }

    private void createSgfIdControllerArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.sgfIdCombo_.createContents(composite2);
        this.sgfIdViewer_ = CheckboxTableViewer.newCheckList((Composite)composite2, (int)68356);
        this.sgfIdViewer_.setLabelProvider((IBaseLabelProvider)new SgfIdLabelProvider());
        Table table = this.sgfIdViewer_.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(false);
        new TableColumn(table, 0x1000000);
        new TableColumn(table, 16384);
        this.sgfIdViewer_.add((Object[])this.sgfIds_);
        this.sgfIdViewer_.setAllChecked(true);
        this.sgfIdViewer_.setAllGrayed(false);
        this.sgfIdViewer_.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                SgfTextDialog.this.updateText();
            }
        });
        for (TableColumn tableColumn : table.getColumns()) {
            tableColumn.pack();
        }
        this.lbLineSize_ = new Label(composite2, 0);
        gridData = new GridData(4, 1024, true, false);
        this.lbLineSize_.setLayoutData((Object)gridData);
    }

    private void createSliderArea(Composite composite) {
        this.scale_ = new Scale(composite, 256);
        GridData gridData = new GridData(4, 1024, true, false);
        this.scale_.setLayoutData((Object)gridData);
        this.scale_.setMinimum(10);
        this.scale_.setMaximum(100);
        this.scale_.setSelection(40);
        this.scale_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SgfTextDialog.this.lbLineSize_.setText(LB_LINE_SIZE.get((Object)String.valueOf(SgfTextDialog.this.scale_.getSelection())));
                SgfTextDialog.this.updateText();
            }
        });
        this.lbLineSize_.setText(LB_LINE_SIZE.get((Object)String.valueOf(this.scale_.getSelection())));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1024, CLB_COPY.get(), false);
        this.createButton(composite, 1, BasicMessages.LB_CANCEL.get(), true);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 1024: {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{this.text_.getText()}, new Transfer[]{textTransfer});
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    static {
        HashSet<SgfId> hashSet = new HashSet<SgfId>();
        hashSet.addAll(Arrays.asList(SgfId.GAME_TYPE, SgfId.SIZE, SgfId.RESULT, SgfId.PLAYER_WHITE, SgfId.PLAYER_BLACK, SgfId.KOMI, SgfId.HANDICAP, SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY, SgfId.WHITE, SgfId.BLACK));
        requisiteIds_ = Collections.unmodifiableSet(hashSet);
    }

    private class SgfIdLabelProvider
    implements ITableLabelProvider {
        private SgfIdLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (!(object instanceof SgfId)) {
                return "";
            }
            SgfId sgfId = (SgfId)object;
            switch (n) {
                case 0: {
                    return sgfId.id();
                }
                case 1: {
                    return sgfId.displayName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private class RgtLabelProvider
    extends LabelProvider {
        private RgtLabelProvider() {
        }

        public String getText(Object object) {
            RootGameTreeLabelProvider rootGameTreeLabelProvider = Yukinoshita.context().getProvider(RootGameTreeLabelProvider.class, null);
            return rootGameTreeLabelProvider.getLabel((RootGameTree)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HandleSgfId {
        MANUAL,
        ALL,
        REQUISITE;


        public String toString() {
            return new MessageResource(((Object)((Object)this)).getClass(), this.name()).get();
        }
    }
}

