/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.io.Ios;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;

class SwtFileChooser
implements IgoFileChooser {
    private static File lastFolder_s_ = Ios.getCurrentDirectory();
    private final IgoFileChooser.Style style_;
    private final FileDialog fileDialog_;

    SwtFileChooser(Shell shell, IgoFileChooser.Style style) {
        int n;
        ArgumentChecker.throwIfNull((Object)shell, (Object)style);
        this.style_ = style;
        switch (style) {
            case OPEN_FILE: {
                n = 4096;
                break;
            }
            case OPEN_FILES: {
                n = 4098;
                break;
            }
            case SAVE_FILE: {
                n = 8192;
                break;
            }
            default: {
                n = 0;
                assert (false) : "Unknown type :" + (Object)((Object)style);
                break;
            }
        }
        this.fileDialog_ = new FileDialog(shell, n | 0x10000);
        this.fileDialog_.setFilterPath(lastFolder_s_.getAbsolutePath());
    }

    public boolean chooseFile() {
        boolean bl = this.fileDialog_.open() != null;
        lastFolder_s_ = this.getFolder();
        return bl;
    }

    public File getFolder() {
        File file;
        for (file = new File(this.fileDialog_.getFilterPath()); file != null && !file.isDirectory(); file = file.getParentFile()) {
        }
        return file == null ? Ios.getCurrentDirectory() : file;
    }

    public File getFile() {
        String string = this.fileDialog_.getFileName();
        return string.length() != 0 ? new File(this.fileDialog_.getFilterPath(), string) : null;
    }

    public File[] getFiles() {
        String[] stringArray = this.fileDialog_.getFileNames();
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new File(this.fileDialog_.getFilterPath(), string));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void setFile(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        this.fileDialog_.setFileName(file.getName());
    }

    public void setFileName(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.fileDialog_.setFileName(string);
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Argument must be a directory:" + file);
        }
        this.fileDialog_.setFilterPath(file.getAbsolutePath());
    }

    public void setFilter(NamedFileFilter[] namedFileFilterArray) {
        ArgumentChecker.throwIfNull((Object)namedFileFilterArray);
        String[] stringArray = new String[namedFileFilterArray.length];
        String[] stringArray2 = new String[namedFileFilterArray.length];
        for (int i = 0; i < namedFileFilterArray.length; ++i) {
            stringArray[i] = namedFileFilterArray[i].displayName();
            String[] stringArray3 = namedFileFilterArray[i].getWildcards();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray3) {
                stringBuilder.append(string).append(", ");
            }
            if (stringArray3.length != 0) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringArray2[i] = stringBuilder.toString();
        }
        this.fileDialog_.setFilterNames(stringArray);
        this.fileDialog_.setFilterExtensions(stringArray2);
    }

    public Shell getParent() {
        return this.fileDialog_.getParent();
    }

    public IgoFileChooser.Style getStyle() {
        return this.style_;
    }

    public String getText() {
        return this.fileDialog_.getText();
    }

    public void setText(String string) {
        this.fileDialog_.setText(string);
    }
}

