/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.gi.GiEmpty;
import org.unitarou.yukinoshita.view.jface.gi.GiEnum;
import org.unitarou.yukinoshita.view.jface.gi.GiFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiLabelFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiTextFormula;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

public class GiItem
implements WidgetContainer,
NodeMonitor {
    private static final Log logger_s_ = LogFactory.getLog(GiItem.class);
    private static final Messages messages_s_ = Messages.createByPackage(GiItem.class);
    private String labelText_ = "";
    private String expression_ = "";
    private final Map<SgfId, String> emptyMap_ = new TreeMap<SgfId, String>();
    private final Map<SgfId, List<GiEnum>> enumMap_ = new TreeMap<SgfId, List<GiEnum>>();
    private Composite composite_;
    private Label label_;
    private GiFormula[] giFormulae_ = new GiFormula[0];

    public static String convert(String string, Properties properties) {
        if (string.startsWith("%")) {
            String string2 = string.substring(1);
            String string3 = properties.getProperty(string2);
            if (string3 == null) {
                logger_s_.warn((Object)("Cannot find the key = " + string2));
                return "";
            }
            return string3;
        }
        return string;
    }

    public Control createContents(Composite composite) {
        this.setup();
        this.composite_ = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(this.giFormulae_.length + 1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 4;
        this.composite_.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(3, 1, false, false);
        this.label_ = new Label(this.composite_, 131072);
        this.label_.setText(this.labelText_);
        this.label_.setLayoutData((Object)gridData);
        for (GiFormula giFormula : this.giFormulae_) {
            Control control = giFormula.createContents(this.composite_);
            gridData = new GridData(1, 1, true, true);
            control.setLayoutData((Object)gridData);
            SgfId sgfId = giFormula.getSgfId();
            if (sgfId == null || !ValueType.TEXT.equals((Object)sgfId.valueType())) continue;
            gridLayout.numColumns = 1;
            ((GridData)this.label_.getLayoutData()).horizontalAlignment = 1;
        }
        return this.composite_;
    }

    public void dispose() {
        if (this.composite_ == null) {
            return;
        }
        this.composite_.dispose();
        this.composite_ = null;
    }

    public void setLabel(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.labelText_ = string;
    }

    public void setExpression(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.expression_ = string;
    }

    public void addEmpty(GiEmpty giEmpty) {
        ArgumentChecker.throwIfNull((Object)giEmpty);
        this.emptyMap_.put(giEmpty.getSgfType(), giEmpty.getValue());
    }

    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull((Object)giEnum);
        List<GiEnum> list = this.enumMap_.get(giEnum.getSgfType());
        if (list == null) {
            list = new ArrayList<GiEnum>();
            this.enumMap_.put(giEnum.getSgfType(), list);
        }
        list.add(giEnum);
    }

    public void setup() {
        ArrayList<GiFormula> arrayList = new ArrayList<GiFormula>();
        StringBuilder stringBuilder = new StringBuilder(this.expression_.length());
        int n = 65535;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.expression_);
        int n2 = stringCharacterIterator.first();
        while (n2 != 65535) {
            if (!Strings.isUppercaseRomanAlphabet((char)n2)) {
                if (n != 65535) {
                    stringBuilder.append((char)n);
                    n = 65535;
                }
                stringBuilder.append((char)n2);
            } else {
                StringBuilder stringBuilder2 = new StringBuilder(2);
                if (n != 65535) {
                    stringBuilder2.append((char)n);
                }
                stringBuilder2.append((char)n2);
                SgfId sgfId = (SgfId)UEnum.find(SgfId.class, (Comparable)((Object)stringBuilder2.toString()));
                if (sgfId == null || !PropertyType.GAME_INFO.equals(sgfId.propertyType())) {
                    if (n != 65535) {
                        stringBuilder.append((char)n);
                    }
                    n = n2;
                } else {
                    List<GiEnum> list;
                    if (stringBuilder.length() != 0) {
                        arrayList.add(new GiLabelFormula(stringBuilder.toString()));
                        stringBuilder.delete(0, stringBuilder.length());
                    }
                    GiTextFormula giTextFormula = new GiTextFormula(sgfId);
                    String string = this.emptyMap_.get(sgfId);
                    if (string != null) {
                        giTextFormula.setEmpty(string);
                    }
                    if ((list = this.enumMap_.get(sgfId)) != null) {
                        for (GiEnum giEnum : list) {
                            String string2 = giEnum.getValue();
                            if (string2.startsWith("%")) {
                                String string3 = string2.substring(1);
                                string2 = messages_s_.get(string3);
                                giEnum.setValue(string2);
                            }
                            giTextFormula.addEnum(giEnum);
                        }
                    }
                    arrayList.add(giTextFormula);
                    n = 65535;
                }
            }
            n2 = stringCharacterIterator.next();
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(new GiLabelFormula(stringBuilder.toString()));
        }
        for (n2 = 0; n2 < this.giFormulae_.length; ++n2) {
            this.giFormulae_[n2].dispose();
        }
        this.giFormulae_ = arrayList.toArray(new GiFormula[arrayList.size()]);
    }

    public void currentChanged(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        for (int i = 0; i < this.giFormulae_.length; ++i) {
            this.giFormulae_[i].currentChanged(nodeView);
        }
    }

    public void setLocalizedLabel(Properties properties) {
        ArgumentChecker.throwIfNull((Object)properties);
        this.labelText_ = GiItem.convert(this.labelText_, properties);
        for (int i = 0; i < this.giFormulae_.length; ++i) {
            this.giFormulae_[i].setLabel(properties);
        }
        for (SgfId sgfId : this.emptyMap_.keySet()) {
            String string = this.emptyMap_.get(sgfId);
            this.emptyMap_.put(sgfId, GiItem.convert(string, properties));
        }
    }

    public void setWidth(int n) {
        Point point = this.label_.computeSize(-1, -1);
        if (((GridLayout)this.composite_.getLayout()).numColumns == 1) {
            point.x = 0;
        }
        for (GiFormula giFormula : this.giFormulae_) {
            Control control = giFormula.getControl();
            GridData gridData = (GridData)control.getLayoutData();
            gridData.widthHint = n - point.x - (gridData.horizontalSpan + gridData.horizontalIndent) * 2;
        }
    }
}

