/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.gi.GiEnum;
import org.unitarou.yukinoshita.view.jface.gi.GiFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiItem;

public class GiTextFormula
implements GiFormula {
    private static final String EMPTY = " ";
    private Label label_;
    private final SgfId sgfType_;
    private String empty_;
    private final List<GiEnum> giEnums_;

    public GiTextFormula(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        this.label_ = null;
        this.sgfType_ = sgfId;
        this.empty_ = EMPTY;
        this.giEnums_ = new ArrayList<GiEnum>();
    }

    public void setEmpty(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.empty_ = string;
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        int n = 64;
        this.label_ = new Label(composite, n);
        return this.label_;
    }

    public void dispose() {
        if (this.label_ == null) {
            return;
        }
        this.label_.dispose();
        this.label_ = null;
    }

    public void currentChanged(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        if (this.label_ == null) {
            throw new IllegalStateException("Can't call before createControl(Composite) called.");
        }
        Property property = nodeView.findProperty(this.sgfType_);
        if (property == null) {
            this.label_.setText(this.empty_);
            return;
        }
        this.updateImpl(property);
        this.label_.setVisible(true);
    }

    private void updateImpl(Property property) {
        Object object;
        String[] stringArray = property.getStrings();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.giEnums_.iterator();
            while (object.hasNext()) {
                GiEnum giEnum = (GiEnum)object.next();
                stringArray[i] = giEnum.replace(stringArray[i]);
            }
            stringBuilder.append(stringArray[i]);
            if (i == 0) continue;
            stringBuilder.append(Strings.LINE_SEPARATOR);
        }
        String string = this.label_.getText();
        if (!string.equals(object = stringBuilder.toString())) {
            this.label_.setText(stringBuilder.toString());
            this.label_.pack();
        }
    }

    public SgfId getSgfId() {
        return this.sgfType_;
    }

    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull((Object)giEnum);
        if (!giEnum.getSgfType().equals(this.sgfType_)) {
            throw new IllegalArgumentException();
        }
        this.giEnums_.add(giEnum);
    }

    public void setLabel(Properties properties) {
        this.empty_ = GiItem.convert(this.empty_, properties);
    }

    public Control getControl() {
        return this.label_;
    }
}

