/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerStatusActions
implements Adaptable {
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Map<HandlerPhase, StatusChangeAction> actionMap_ = new HashMap<HandlerPhase, StatusChangeAction>();
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public Action[] getActions() {
        StateHandler stateHandler = this.eventBroker_.getCurrentStateHander();
        if (stateHandler == null) {
            return new Action[0];
        }
        HandlerPhase[] handlerPhaseArray = stateHandler.getHandlerPhases();
        ArrayList<StatusChangeAction> arrayList = new ArrayList<StatusChangeAction>(handlerPhaseArray.length);
        for (int i = 0; i < handlerPhaseArray.length; ++i) {
            arrayList.add(this.getOrMakeAction(handlerPhaseArray[i]));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public void setEventBroker(EventBroker eventBroker) {
        this.adapter_.setEventBroker(eventBroker);
    }

    private StatusChangeAction getOrMakeAction(HandlerPhase handlerPhase) {
        StatusChangeAction statusChangeAction = this.actionMap_.get(handlerPhase);
        if (statusChangeAction == null) {
            statusChangeAction = new StatusChangeAction(handlerPhase);
            this.actionMap_.put(handlerPhase, statusChangeAction);
        }
        return statusChangeAction;
    }

    private class Adapter
    implements ModelEventNotifier,
    ControllerStatusMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            HandlerStatusActions.this.eventBroker_.removeView(HandlerStatusActions.this);
            HandlerStatusActions.this.eventBroker_ = eventBroker;
            HandlerStatusActions.this.eventBroker_.addView(HandlerStatusActions.this);
        }

        public void setEditMode(boolean bl) {
            HandlerPhase[] handlerPhaseArray2;
            for (HandlerPhase[] handlerPhaseArray2 : HandlerStatusActions.this.actionMap_.values()) {
                handlerPhaseArray2.setEnabled(false);
                handlerPhaseArray2.setChecked(false);
            }
            StateHandler stateHandler = HandlerStatusActions.this.eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            handlerPhaseArray2 = stateHandler.getHandlerPhases();
            for (int i = 0; i < handlerPhaseArray2.length; ++i) {
                HandlerStatusActions.this.getOrMakeAction(handlerPhaseArray2[i]).setEnabled(true);
            }
            if (handlerPhaseArray2.length != 0) {
                StatusChangeAction statusChangeAction = (StatusChangeAction)((Object)HandlerStatusActions.this.actionMap_.get(handlerPhaseArray2[0]));
                statusChangeAction.setChecked(true);
            }
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            StateHandler stateHandler = HandlerStatusActions.this.eventBroker_.getCurrentStateHander();
            if (stateHandler == null) {
                return;
            }
            HandlerPhase[] handlerPhaseArray = stateHandler.getHandlerPhases();
            for (int i = 0; i < handlerPhaseArray.length; ++i) {
                StatusChangeAction statusChangeAction = HandlerStatusActions.this.getOrMakeAction(handlerPhaseArray[i]);
                statusChangeAction.setChecked(handlerPhase.equals(handlerPhaseArray[i]));
            }
        }
    }

    private class StatusChangeAction
    extends Action {
        private final HandlerPhase handlerStatus_;

        private StatusChangeAction(HandlerPhase handlerPhase) {
            super(handlerPhase.displayName(), 8);
            assert (handlerPhase != null);
            this.handlerStatus_ = handlerPhase;
            this.setId(handlerPhase.displayName());
            this.setEnabled(false);
        }

        public void run() {
            if (this.isChecked()) {
                HandlerStatusActions.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(this.handlerStatus_));
            }
        }
    }
}

