/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoGraphicalBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.DrillEditorStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.GameViewStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.ProblemViewStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.ver1.EditorStateHandlerVer1;
import org.unitarou.yukinoshita.view.jface.dr.DrillViewerPanel;
import org.unitarou.yukinoshita.view.jface.gm.NodeStatusPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainViewPanel
implements Adaptable,
WidgetContainer {
    private static final IntContextValue STATUS_HEIGHT = new IntContextValue(MainViewPanel.class, "statusWidth", 0, 25, 120);
    private Composite mainFrame_ = null;
    private final StackLayout stackLayout4MainFrame_ = new StackLayout();
    private USashForm boardFrame_ = null;
    private final IgoBoardPanel boardPanel_ = new IgoGraphicalBoardPanel();
    private final NodeStatusPanel statusPanel_;
    private final DrillViewerPanel drillViewerPanel_ = new DrillViewerPanel();
    private Control drillViewerControl_ = null;
    private final Adapter adapter_;

    public MainViewPanel() {
        this.statusPanel_ = new NodeStatusPanel();
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.mainFrame_ = new Composite(composite, 0);
        this.mainFrame_.setLayout((Layout)this.stackLayout4MainFrame_);
        this.boardFrame_ = WidgetFactory.createUSashForm(this.mainFrame_, 512);
        this.boardPanel_.createContents(this.boardFrame_);
        this.statusPanel_.createContents(this.boardFrame_);
        this.drillViewerControl_ = this.drillViewerPanel_.createContents(this.mainFrame_);
        CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
        int n = currentContext.getInteger(STATUS_HEIGHT);
        this.boardFrame_.setWeights(new int[]{1, -n});
        return this.mainFrame_;
    }

    @Override
    public void dispose() {
        this.boardPanel_.dispose();
        this.drillViewerPanel_.dispose();
        this.statusPanel_.dispose();
    }

    private class Adapter
    extends TieredModelEventNotifier
    implements GameMonitor,
    CollectionMonitor,
    ControllerStatusMonitor,
    LayoutMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private final Adaptable[] adaptables_;
        private Collection collection_;
        private boolean isEditMode_;

        public Adapter() {
            this.adaptables_ = new Adaptable[]{MainViewPanel.this.boardPanel_, MainViewPanel.this.drillViewerPanel_, MainViewPanel.this.statusPanel_};
            this.collection_ = null;
            this.isEditMode_ = false;
        }

        protected Adaptable[] getAdaptables() {
            return this.adaptables_;
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(MainViewPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(MainViewPanel.this);
            eventBroker.register(GameType.GAME, false, new GameViewStateHandler(MainViewPanel.this.boardPanel_));
            eventBroker.register(GameType.GAME, true, new EditorStateHandlerVer1(MainViewPanel.this.boardPanel_));
            eventBroker.register(GameType.PROBLEM, false, new ProblemViewStateHandler(MainViewPanel.this.boardPanel_));
            eventBroker.register(GameType.PROBLEM, true, new EditorStateHandlerVer1(MainViewPanel.this.boardPanel_));
            eventBroker.register(GameType.DRILL, true, new DrillEditorStateHandler(MainViewPanel.this.boardPanel_));
            super.setEventBroker(eventBroker);
        }

        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull((Object)collectionEditor);
            this.collection_ = collectionEditor.getCollection();
            this.update();
        }

        public void update(GameMediator gameMediator) {
            this.update();
        }

        public void setEditMode(boolean bl) {
            this.isEditMode_ = bl;
            this.update();
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        private void update() {
            ((MainViewPanel)MainViewPanel.this).stackLayout4MainFrame_.topControl = !this.isEditMode_ ? MainViewPanel.this.boardFrame_ : (GameType.DRILL.equals(this.collection_.get(0).getGameType()) ? MainViewPanel.this.drillViewerControl_ : MainViewPanel.this.boardFrame_);
            ((MainViewPanel)MainViewPanel.this).stackLayout4MainFrame_.topControl.getParent().layout();
        }

        public void defaultLayout() {
            MainViewPanel.this.boardFrame_.setWeights(new int[]{1, -STATUS_HEIGHT.defaultInt()});
        }

        public void loadLayout() {
            CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
            int n = currentContext.getInteger(STATUS_HEIGHT);
            MainViewPanel.this.boardFrame_.setWeights(new int[]{1, -n});
        }

        public void saveLayout() {
            CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
            int n = ((MainViewPanel)MainViewPanel.this).statusPanel_.getControl().getSize().y;
            currentContext.setInteger(STATUS_HEIGHT.id(), n);
        }
    }
}

