/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.view.jface.ns.VariationSelectorPanel;

public class MoveButton {
    private final VariationSelectorPanel variationSelectorPanel_;
    private Button button_;
    private final int index_;

    public MoveButton(VariationSelectorPanel variationSelectorPanel, int n) {
        if (variationSelectorPanel == null) {
            throw new NullArgumentException("Argument(variationSelectorPanel) must not be null.");
        }
        this.index_ = n;
        this.variationSelectorPanel_ = variationSelectorPanel;
        this.button_ = null;
    }

    public void createControl(Composite composite, int n) {
        this.button_ = new Button(composite, n);
        this.button_.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MoveButton.this.disposeButtonImage();
            }
        });
        this.button_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!((Button)selectionEvent.widget).getSelection()) {
                    return;
                }
                MoveButton.this.variationSelectorPanel_.variationChanged(MoveButton.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String string, ImageResource imageResource, String string2) {
        Image image = imageResource.get();
        GC gC = new GC((Drawable)this.button_);
        try {
            Painter painter = new Painter();
            painter.set(gC, string, image, string2);
            this.disposeButtonImage();
            this.button_.setImage(new Image((Device)this.button_.getDisplay(), ((Painter)painter).totalSp_.x, ((Painter)painter).totalSp_.y));
            this.paint(painter);
        }
        finally {
            gC.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(Painter painter) {
        GC gC = new GC((Drawable)this.button_.getImage());
        try {
            gC.setFont(this.button_.getFont());
            gC.setBackground(this.button_.getBackground());
            gC.setForeground(this.button_.getForeground());
            painter.paint(gC);
        }
        finally {
            gC.dispose();
        }
    }

    private void disposeButtonImage() {
        if (this.button_ == null) {
            return;
        }
        Image image = this.button_.getImage();
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
        this.button_.setImage(null);
    }

    public void setVisible(boolean bl) {
        this.button_.setVisible(bl);
    }

    public void setSelection(boolean bl) {
        this.button_.setSelection(bl);
    }

    public int getIndex() {
        return this.index_;
    }

    private static class Painter {
        private String prefix_;
        private Image image_;
        private String postfix_;
        private Point prefixSp_;
        private Point imageSp_;
        private Point postfixSp_;
        private Point totalSp_;

        private Painter() {
        }

        private void set(GC gC, String string, Image image, String string2) {
            this.prefix_ = string;
            this.image_ = image;
            this.postfix_ = string2;
            this.prefixSp_ = gC.textExtent(this.prefix_, 8);
            this.imageSp_ = Geometry.getSize((Rectangle)this.image_.getBounds());
            this.postfixSp_ = gC.textExtent(this.postfix_, 8);
            this.totalSp_ = Swts.add(this.prefixSp_, this.imageSp_, 256);
            this.totalSp_ = Swts.add(this.totalSp_, this.postfixSp_, 256);
        }

        private void paint(GC gC) {
            gC.fillRectangle(0, 0, this.totalSp_.x, this.totalSp_.y);
            gC.drawText(this.prefix_, 0, (this.totalSp_.y - this.prefixSp_.y) / 2, 8);
            gC.drawImage(this.image_, this.prefixSp_.x, (this.totalSp_.y - this.imageSp_.y) / 2);
            gC.drawText(this.postfix_, this.prefixSp_.x + this.imageSp_.x, (this.totalSp_.y - this.postfixSp_.y) / 2, 8);
        }
    }
}

