/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.rgtlp;

import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Handicap;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.view.provider.rgtlp.DefaultRgtLabelProvider;

public class GreedyRgtLabelProvider
extends DefaultRgtLabelProvider {
    public String displayName() {
        return super.displayName();
    }

    public String getLabel(RootGameTree rootGameTree) {
        String string = super.getLabel(rootGameTree);
        if (string.length() != 0) {
            return string;
        }
        switch (rootGameTree.getGameType()) {
            case GAME: {
                return this.getLabelAsGame(rootGameTree);
            }
            case PROBLEM: {
                return this.getLabelAsProblem(rootGameTree);
            }
            case DRILL: {
                return this.getLabelAsDrill(rootGameTree);
            }
        }
        return string;
    }

    private String getLabelAsGame(RootGameTree rootGameTree) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GameType.GAME.displayName()).append('[').append(rootGameTree.getSize().toString()).append(',');
        String string = this.makeHandicapLabel(rootGameTree);
        if (string.length() != 0) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(this.countMoves(rootGameTree)).append("\u624b").append(']');
        return stringBuilder.toString();
    }

    private String makeHandicapLabel(RootGameTree rootGameTree) {
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.HANDICAP);
        if (string.length() == 0) {
            return "";
        }
        SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
        if (sgfNumber == null) {
            return "";
        }
        Handicap handicap = new Handicap(sgfNumber.getIntValue());
        return handicap.displayName();
    }

    private int countMoves(RootGameTree rootGameTree) {
        int n = 0;
        RootGameTree rootGameTree2 = rootGameTree;
        while (rootGameTree2 != null) {
            Sequence sequence = rootGameTree2.getSequence();
            for (Node node : sequence) {
                if (!node.contains(SgfId.BLACK) && !node.contains(SgfId.WHITE)) continue;
                ++n;
            }
            rootGameTree2 = rootGameTree2.getChildrenSize() == 0 ? null : rootGameTree2.getChild(0);
        }
        return n;
    }

    private String getLabelAsProblem(RootGameTree rootGameTree) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GameType.PROBLEM.displayName()).append('[');
        String string = this.makeResultLabel(rootGameTree);
        if (string.length() != 0) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(this.countMoves(rootGameTree)).append("\u624b").append(']');
        return stringBuilder.toString();
    }

    private String makeResultLabel(RootGameTree rootGameTree) {
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.RESULT);
        if (string.length() == 0) {
            return "";
        }
        Result result = Result.parse(string);
        switch (result.getArchetype()) {
            case OTHER: {
                return result.getValue();
            }
            case BLACK_WIN: 
            case WHITE_WIN: {
                return result.getArchetype().displayName() + result.getScore();
            }
        }
        return result.getArchetype().displayName();
    }

    private String getLabelAsDrill(RootGameTree rootGameTree) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GameType.DRILL.displayName()).append('[').append(this.countProblems(rootGameTree)).append("\u554f").append(']');
        return stringBuilder.toString();
    }

    private int countProblems(RootGameTree rootGameTree) {
        String[] stringArray = BasicFinder.findData(rootGameTree.getSequence(), SgfId.INPUT_FILES);
        if (stringArray == null) {
            return 0;
        }
        return stringArray.length;
    }
}

