/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.swing.AboutDialog;
import ccl.swing.AnimationPanel;
import ccl.swing.AutoGridBagLayout;
import ccl.swing.MainJFrame;
import ccl.swing.SwingUtil;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javancss.Javancss;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.SoftBevelBorder;

public class JavancssFrame
extends MainJFrame {
    public static final String S_PACKAGES = "Packages";
    public static final String S_CLASSES = "Classes";
    public static final String S_METHODS = "Methods";
    private static final String S_MN_F_SAVE = "Save";
    private int _oldThreadPriority = -1;
    private AnimationPanel _pAnimationPanel = null;
    private JTextArea _txtPackage;
    private JTextArea _txtObject;
    private JTextArea _txtFunction;
    private JTextArea _txtError;
    private JTabbedPane _pTabbedPane = null;
    private Font pFont = new Font("Monospaced", 0, 12);
    private boolean _bNoError = true;
    private String _sProjectName = null;
    private String _sProjectPath = null;
    private Init _pInit = null;
    private boolean _bStop = false;
    private boolean _bSave = false;
    private boolean _bAboutSelected = false;

    public void save() {
        String sFullProjectName = FileUtil.concatPath(this._sProjectPath, this._sProjectName.toLowerCase());
        String sPackagesFullFileName = sFullProjectName + ".packages.txt";
        String sClassesFullFileName = sFullProjectName + ".classes.txt";
        String sMethodsFullFileName = sFullProjectName + ".methods.txt";
        String sSuccessMessage = "Data appended successfully to the following files:";
        try {
            FileUtil.appendFile(sPackagesFullFileName, this._txtPackage.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sPackagesFullFileName;
        }
        catch (Exception ePackages) {
            SwingUtil.showMessage(this, "Error: could not append to file '" + sPackagesFullFileName + "'.\n" + ePackages);
        }
        try {
            FileUtil.appendFile(sClassesFullFileName, this._txtObject.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sClassesFullFileName;
        }
        catch (Exception eClasses) {
            SwingUtil.showMessage(this, "Error: could not append to file '" + sClassesFullFileName + "'.\n" + eClasses);
        }
        try {
            FileUtil.appendFile(sMethodsFullFileName, this._txtFunction.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sMethodsFullFileName;
        }
        catch (Exception eMethods) {
            SwingUtil.showMessage(this, "Error: could not append to file '" + sMethodsFullFileName + "'.\n" + eMethods);
        }
        SwingUtil.showMessage(this, sSuccessMessage);
    }

    private void _setMenuBar() {
        Vector vMenus = new Vector();
        Vector<String> vFileMenu = new Vector<String>();
        Vector<String> vHelpMenu = new Vector<String>();
        vFileMenu.addElement("File");
        vFileMenu.addElement(S_MN_F_SAVE);
        vFileMenu.addElement("Exit");
        vHelpMenu.addElement("Help");
        vHelpMenu.addElement("&Contents...");
        vHelpMenu.addElement("---");
        vHelpMenu.addElement("About...");
        vMenus.addElement(vFileMenu);
        vMenus.addElement(vHelpMenu);
        this.setMenuBar(vMenus);
    }

    public Init getInit() {
        return this._pInit;
    }

    public JavancssFrame(Init pInit_) {
        super("JavaNCSS: " + pInit_.getFileName());
        this._pInit = pInit_;
        this.getInit().setAuthor("Chr. Clemens Lee");
        super.setBackground(this._pInit.getBackground());
        this._sProjectName = pInit_.getFileName();
        this._sProjectPath = pInit_.getFilePath();
        if (Util.isEmpty(this._sProjectName)) {
            this._sProjectName = pInit_.getApplicationName();
            this._sProjectPath = pInit_.getApplicationPath();
        }
        this._setMenuBar();
        this._bAboutSelected = false;
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        this.getContentPane().setLayout(pAutoGridBagLayout);
        Image pImage = Toolkit.getDefaultToolkit().getImage(SwingUtil.createCCLBorder().getClass().getResource("anim_recycle_brown.gif"));
        this._pAnimationPanel = new AnimationPanel(pImage, 350L);
        JPanel pPanel = new JPanel();
        pPanel.setBorder(new SoftBevelBorder(1));
        pPanel.add((Component)this._pAnimationPanel, "Center");
        this.getContentPane().add(pPanel);
        this.pack();
        ((Component)this).setSize(640, 480);
        SwingUtil.centerComponent(this);
    }

    public void showJavancss(Javancss pJavancss_) {
        this._bStop = false;
        this._bSave = false;
        if (this._oldThreadPriority != -1) {
            Thread.currentThread().setPriority(this._oldThreadPriority);
            this._pAnimationPanel.stop();
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this._bNoError = true;
        if (pJavancss_.getLastErrorMessage() != null && pJavancss_.getNcss() <= 0) {
            this._bNoError = false;
            JTextArea txtError = new JTextArea();
            String sError = "Error in Javancss: " + pJavancss_.getLastErrorMessage();
            txtError.setText(sError);
            JScrollPane jspError = new JScrollPane(txtError);
            this.getContentPane().add((Component)jspError, "Center");
        } else {
            Util.debug("JavancssFrame.showJavancss(..).NOERROR");
            JPanel pPanel = new JPanel(true);
            pPanel.setLayout(new BorderLayout());
            this._pTabbedPane = new JTabbedPane();
            this._pTabbedPane.setDoubleBuffered(true);
            this._txtPackage = new JTextArea();
            this._txtPackage.setFont(this.pFont);
            JScrollPane jspPackage = new JScrollPane(this._txtPackage);
            int inset = 5;
            jspPackage.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_PACKAGES, null, jspPackage);
            this._txtObject = new JTextArea();
            this._txtObject.setFont(this.pFont);
            JScrollPane jspObject = new JScrollPane(this._txtObject);
            jspObject.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_CLASSES, null, jspObject);
            this._txtFunction = new JTextArea();
            this._txtFunction.setFont(this.pFont);
            JScrollPane jspFunction = new JScrollPane(this._txtFunction);
            jspFunction.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_METHODS, null, jspFunction);
            String sTimeZoneID = System.getProperty("user.timezone");
            if (sTimeZoneID.equals("CET")) {
                sTimeZoneID = "ECT";
            }
            TimeZone pTimeZone = TimeZone.getTimeZone(sTimeZoneID);
            Util.debug("JavancssFrame.showJavancss(..).pTimeZone.getID(): " + pTimeZone.getID());
            SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("EEE, MMM dd, yyyy  HH:mm:ss");
            pSimpleDateFormat.setTimeZone(pTimeZone);
            String sDate = pSimpleDateFormat.format(new Date()) + " " + pTimeZone.getID();
            this._txtPackage.setText(sDate + "\n\n" + pJavancss_.printPackageNcss());
            this._txtObject.setText(sDate + "\n\n" + pJavancss_.printObjectNcss());
            this._txtFunction.setText(sDate + "\n\n" + pJavancss_.printFunctionNcss());
            if (pJavancss_.getLastErrorMessage() != null) {
                this._txtError = new JTextArea();
                String sError = "Errors in Javancss:\n\n" + pJavancss_.getLastErrorMessage();
                this._txtError.setText(sError);
                JScrollPane jspError = new JScrollPane(this._txtError);
                jspError.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
                this.getContentPane().add((Component)jspError, "Center");
                this._pTabbedPane.addTab("Errors", null, jspError);
            }
            pPanel.add((Component)this._pTabbedPane, "Center");
            this.getContentPane().add((Component)pPanel, "Center");
        }
        this.validate();
        this.repaint();
    }

    public void run() {
        this._bSave = false;
        while (!this._bStop) {
            if (this._bSave) {
                this.save();
                this._bSave = false;
            }
            if (this.isExitSet()) {
                this.exit();
                this._bStop = true;
                break;
            }
            if (this._bAboutSelected) {
                this._bAboutSelected = false;
                AboutDialog dlgAbout = new AboutDialog((Frame)this, this.getInit().getAuthor(), "$Header: /home/clemens/src/java/javancss/src/javancss/RCS/Main.java,v 21.41 2002/09/06 20:48:38 clemens Exp clemens $");
                dlgAbout.dispose();
                this.requestFocus();
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean bVisible_) {
        if (bVisible_) {
            this._oldThreadPriority = Thread.currentThread().getPriority();
            this._pAnimationPanel.start();
            Thread.currentThread().setPriority(1);
        } else {
            this._pAnimationPanel.stop();
        }
        super.setVisible(bVisible_);
    }

    public void setSelectedTab(String sTab_) {
        Util.panicIf(Util.isEmpty(sTab_));
        if (!this._bNoError) {
            return;
        }
        if (sTab_.equals(S_METHODS)) {
            this._pTabbedPane.setSelectedIndex(2);
        } else if (sTab_.equals(S_CLASSES)) {
            this._pTabbedPane.setSelectedIndex(1);
        } else {
            this._pTabbedPane.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Util.debug("JavancssFrame.actionPerformed(..).1");
        Object oSource = pActionEvent_.getSource();
        if (oSource instanceof JMenuItem) {
            String sMenuItem = ((JMenuItem)oSource).getText();
            if (sMenuItem.equals("Beenden") || sMenuItem.equals("Exit")) {
                this.processWindowEvent(new WindowEvent(this, 201));
            } else if (sMenuItem.equals(S_MN_F_SAVE)) {
                this._bSave = true;
            } else if (sMenuItem.equals("Info...") || sMenuItem.equals("About...") || sMenuItem.equals("Info") || sMenuItem.equals("About")) {
                this._bAboutSelected = true;
            } else if (sMenuItem.equals("Inhalt...") || sMenuItem.equals("Contents...") || sMenuItem.equals("Inhalt") || sMenuItem.equals("Contents")) {
                String sStartURL = FileUtil.concatPath(FileUtil.getPackagePath("javancss"), "doc") + File.separator + "index.html";
                if (Util.isEmpty(sStartURL)) {
                    return;
                }
                if ((sStartURL = sStartURL.replace('\\', '/')).charAt(0) != '/') {
                    sStartURL = "/" + sStartURL;
                }
                sStartURL = "file:" + sStartURL;
                Util.debug("JavancssFrame.actionPerformed(): sStartURL: " + sStartURL);
                try {
                    URL urlHelpDocument = new URL(sStartURL);
                }
                catch (Exception pException) {
                    Util.debug("JavancssFrame.actionPerformed(..).pException: " + pException);
                }
            }
        }
    }
}

