/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.cobertura.ant.Regex;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CheckTask
extends MatchingTask {
    private String dataFile = null;
    final Set regexes = new HashSet();
    private String branchRate = null;
    private String lineRate = null;
    private String totalBranchRate = null;
    private String totalLineRate = null;
    private String failureProperty = null;
    private boolean haltOnFailure = true;
    private Java java = null;

    public void execute() throws BuildException {
        if (this.dataFile != null) {
            this.getJava().createArg().setValue("--datafile");
            this.getJava().createArg().setValue(this.dataFile);
        }
        if (this.branchRate != null) {
            this.getJava().createArg().setValue("--branch");
            this.getJava().createArg().setValue(this.branchRate);
        }
        if (this.lineRate != null) {
            this.getJava().createArg().setValue("--line");
            this.getJava().createArg().setValue(this.lineRate);
        }
        if (this.totalBranchRate != null) {
            this.getJava().createArg().setValue("--totalbranch");
            this.getJava().createArg().setValue(this.totalBranchRate);
        }
        if (this.totalLineRate != null) {
            this.getJava().createArg().setValue("--totalline");
            this.getJava().createArg().setValue(this.totalLineRate);
        }
        Iterator iter = this.regexes.iterator();
        while (iter.hasNext()) {
            this.getJava().createArg().setValue("--regex");
            this.getJava().createArg().setValue(iter.next().toString());
        }
        int returnCode = this.getJava().executeJava();
        if (returnCode == 0) {
            System.out.println("All checks passed.");
        } else {
            if (this.haltOnFailure) {
                throw new BuildException("Coverage check failed. See messages above.");
            }
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, "true");
            } else {
                System.err.println("Coverage check failed. See messages above.");
            }
        }
    }

    public Regex createRegex() {
        Regex regex = new Regex();
        this.regexes.add(regex);
        return regex;
    }

    protected Java getJava() {
        if (this.java == null) {
            this.java = (Java)this.getProject().createTask("java");
            this.java.setTaskName(this.getTaskName());
            this.java.setClassname("net.sourceforge.cobertura.check.Main");
            this.java.setFork(true);
            this.java.setDir(this.getProject().getBaseDir());
            if (((Object)((Object)this)).getClass().getClassLoader() instanceof AntClassLoader) {
                this.createClasspath().setPath(((AntClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getClasspath());
            } else if (((Object)((Object)this)).getClass().getClassLoader() instanceof URLClassLoader) {
                URL[] earls = ((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getURLs();
                int i = 0;
                while (i < earls.length) {
                    this.createClasspath().setPath(earls[i].getFile());
                    ++i;
                }
            }
        }
        return this.java;
    }

    public Path createClasspath() {
        return this.getJava().createClasspath().createPath();
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public void setBranchRate(String branchRate) {
        this.branchRate = branchRate;
    }

    public void setLineRate(String lineRate) {
        this.lineRate = lineRate;
    }

    public void setTotalBranchRate(String totalBranchRate) {
        this.totalBranchRate = totalBranchRate;
    }

    public void setTotalLineRate(String totalLineRate) {
        this.totalLineRate = totalLineRate;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }
}

