/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cobertura.ant.CommonMatchingTask;
import net.sourceforge.cobertura.ant.Ignore;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import org.apache.tools.ant.BuildException;

public class InstrumentTask
extends CommonMatchingTask {
    private String dataFile = null;
    private File toDir = null;
    Ignore ignoreRegex = null;

    public InstrumentTask() {
        super("net.sourceforge.cobertura.instrument.Main");
    }

    public Ignore createIgnore() {
        this.ignoreRegex = new Ignore();
        return this.ignoreRegex;
    }

    public void execute() throws BuildException {
        CommandLineBuilder builder = null;
        try {
            builder = new CommandLineBuilder();
            if (this.dataFile != null) {
                builder.addArg("--datafile", this.dataFile);
            }
            if (this.toDir != null) {
                builder.addArg("--destination", this.toDir.getAbsolutePath());
            }
            if (this.ignoreRegex != null) {
                builder.addArg("--ignore", this.ignoreRegex.getRegex());
            }
            this.createArgumentsForFilesets(builder);
            builder.saveArgs();
        }
        catch (IOException ioe) {
            this.getProject().log("Error creating commands file.", 0);
            throw new BuildException("Unable to create the commands file.", (Throwable)ioe);
        }
        this.getJava().createArg().setValue("--commandsfile");
        this.getJava().createArg().setValue(builder.getCommandLineFile());
        if (this.getJava().executeJava() != 0) {
            throw new BuildException("Error instrumenting classes. See messages above.");
        }
        builder.dispose();
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }
}

