/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.ant;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cobertura.ant.CommonMatchingTask;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import org.apache.tools.ant.BuildException;

public class ReportTask
extends CommonMatchingTask {
    private String dataFile = null;
    private String format = "html";
    private File destDir;
    private String srcDir;

    public ReportTask() {
        super("net.sourceforge.cobertura.reporting.Main");
    }

    public void execute() throws BuildException {
        CommandLineBuilder builder = null;
        try {
            builder = new CommandLineBuilder();
            if (this.dataFile != null) {
                builder.addArg("--datafile", this.dataFile);
            }
            if (this.destDir != null) {
                builder.addArg("--destination", this.destDir.getAbsolutePath());
            }
            if (this.format != null) {
                builder.addArg("--format", this.format);
            }
            if (this.srcDir != null) {
                builder.addArg(this.srcDir);
            }
            this.createArgumentsForFilesets(builder);
            builder.saveArgs();
        }
        catch (IOException ioe) {
            this.getProject().log("Error creating commands file.", 0);
            throw new BuildException("Unable to create the commands file.", (Throwable)ioe);
        }
        this.getJava().createArg().setValue("--commandsfile");
        this.getJava().createArg().setValue(builder.getCommandLineFile());
        if (this.getJava().executeJava() != 0) {
            throw new BuildException("Error running reports. See messages above.");
        }
        builder.dispose();
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSrcDir(String dir) {
        this.srcDir = dir;
    }
}

