/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.SaveTimer;

public class ProjectData
extends CoverageDataContainer
implements HasBeenInstrumented {
    private static final long serialVersionUID = 6L;
    private static ProjectData globalProjectData = null;
    private static SaveTimer saveTimer = null;
    private Map sourceFiles = new HashMap();
    private Map classes = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$ClassData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$CoverageData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$LineData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$PackageData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$SourceFileData;

    public void addClassData(ClassData classData) {
        String packageName = classData.getPackageName();
        PackageData packageData = (PackageData)this.children.get(packageName);
        if (packageData == null) {
            packageData = new PackageData(packageName);
            this.children.put(packageName, packageData);
        }
        packageData.addClassData(classData);
        this.sourceFiles.put(classData.getSourceFileName(), packageData.getChild(classData.getSourceFileName()));
        this.classes.put(classData.getName(), classData);
    }

    public ClassData getClassData(String name) {
        return (ClassData)this.classes.get(name);
    }

    public ClassData getOrCreateClassData(String name) {
        ClassData classData = (ClassData)this.classes.get(name);
        if (classData == null) {
            classData = new ClassData(name);
            this.addClassData(classData);
        }
        return classData;
    }

    public Collection getClasses() {
        return this.classes.values();
    }

    public int getNumberOfClasses() {
        return this.classes.size();
    }

    public int getNumberOfSourceFiles() {
        return this.sourceFiles.size();
    }

    public SortedSet getPackages() {
        return new TreeSet(this.children.values());
    }

    public Collection getSourceFiles() {
        return this.sourceFiles.values();
    }

    public SortedSet getSubPackages(String packageName) {
        TreeSet<PackageData> subPackages = new TreeSet<PackageData>();
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            if (!packageData.getName().startsWith(packageName)) continue;
            subPackages.add(packageData);
        }
        return subPackages;
    }

    public void merge(CoverageData coverageData) {
        super.merge(coverageData);
        ProjectData projectData = (ProjectData)coverageData;
        Iterator iter = projectData.sourceFiles.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (this.sourceFiles.containsKey(key)) continue;
            this.sourceFiles.put(key, projectData.sourceFiles.get(key));
        }
        Iterator iter2 = projectData.classes.keySet().iterator();
        while (iter2.hasNext()) {
            Object key = iter2.next();
            if (this.classes.containsKey(key)) continue;
            this.classes.put(key, projectData.classes.get(key));
        }
    }

    public static ProjectData getGlobalProjectData() {
        if (globalProjectData != null) {
            return globalProjectData;
        }
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        if (dataFile.isFile()) {
            globalProjectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (globalProjectData == null) {
            System.out.println("Cobertura: Coverage data file " + dataFile.getAbsolutePath() + " either does not exist or is not readable.  Creating a new data file.");
            globalProjectData = new ProjectData();
        }
        if (System.getProperty("catalina.home") != null) {
            ProjectData.saveGlobalProjectData();
            (class$net$sourceforge$cobertura$coveragedata$ClassData == null ? (class$net$sourceforge$cobertura$coveragedata$ClassData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.ClassData")) : class$net$sourceforge$cobertura$coveragedata$ClassData).toString();
            (class$net$sourceforge$cobertura$coveragedata$CoverageData == null ? (class$net$sourceforge$cobertura$coveragedata$CoverageData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.CoverageData")) : class$net$sourceforge$cobertura$coveragedata$CoverageData).toString();
            (class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer == null ? (class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer = ProjectData.class$("net.sourceforge.cobertura.coveragedata.CoverageDataContainer")) : class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer).toString();
            (class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented == null ? (class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented = ProjectData.class$("net.sourceforge.cobertura.coveragedata.HasBeenInstrumented")) : class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented).toString();
            (class$net$sourceforge$cobertura$coveragedata$LineData == null ? (class$net$sourceforge$cobertura$coveragedata$LineData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.LineData")) : class$net$sourceforge$cobertura$coveragedata$LineData).toString();
            (class$net$sourceforge$cobertura$coveragedata$PackageData == null ? (class$net$sourceforge$cobertura$coveragedata$PackageData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.PackageData")) : class$net$sourceforge$cobertura$coveragedata$PackageData).toString();
            (class$net$sourceforge$cobertura$coveragedata$SourceFileData == null ? (class$net$sourceforge$cobertura$coveragedata$SourceFileData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.SourceFileData")) : class$net$sourceforge$cobertura$coveragedata$SourceFileData).toString();
        }
        saveTimer = new SaveTimer();
        Runtime.getRuntime().addShutdownHook(new Thread(saveTimer));
        return globalProjectData;
    }

    public static void saveGlobalProjectData() {
        ProjectData projectData;
        ProjectData projectData2 = projectData = ProjectData.getGlobalProjectData();
        synchronized (projectData2) {
            CoverageDataFileHandler.saveCoverageData(projectData, CoverageDataFileHandler.getDefaultDataFile());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

